/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.server.webcomponent.PropertyConfigurationImpl;
import com.vaadin.flow.server.webcomponent.PropertyData;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.LoggerFactory;

public final class WebComponentBinding<C extends Component>
implements Serializable {
    private C component;
    private HashMap<String, PropertyBinding<? extends Serializable>> properties = new HashMap();

    public WebComponentBinding(C component) {
        Objects.requireNonNull(component, "Parameter 'component' must not be null!");
        this.component = component;
    }

    public void updateProperty(String propertyName, Serializable value) {
        Objects.requireNonNull(propertyName, "Parameter 'propertyName' must not be null!");
        PropertyBinding<? extends Serializable> propertyBinding = this.properties.get(propertyName);
        if (propertyBinding == null) {
            throw new IllegalArgumentException(String.format("No %s found for propertyName '%s'!", PropertyData.class.getSimpleName(), propertyName));
        }
        propertyBinding.updateValue(value);
    }

    public void updateProperty(String propertyName, JsonValue jsonValue) {
        Objects.requireNonNull(propertyName, "Parameter 'propertyName' must not be null!");
        Class<Serializable> propertyType = this.getPropertyType(propertyName);
        Serializable value = this.jsonValueToConcreteType(jsonValue, propertyType);
        this.updateProperty(propertyName, value);
    }

    public C getComponent() {
        return this.component;
    }

    public Class<? extends Serializable> getPropertyType(String propertyName) {
        if (this.hasProperty(propertyName)) {
            return this.properties.get(propertyName).getType();
        }
        return null;
    }

    public boolean hasProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public void updatePropertiesToComponent() {
        this.properties.forEach((key, value) -> value.notifyValueChange());
    }

    public void bindProperty(PropertyConfigurationImpl<C, ? extends Serializable> propertyConfiguration, boolean overrideDefault, JsonValue startingValue) {
        Objects.requireNonNull(propertyConfiguration, "Parameter 'propertyConfiguration' cannot be null!");
        SerializableBiConsumer<C, Serializable> consumer = propertyConfiguration.getOnChangeHandler();
        Serializable selectedStartingValue = !overrideDefault ? propertyConfiguration.getPropertyData().getDefaultValue() : this.jsonValueToConcreteType(startingValue, propertyConfiguration.getPropertyData().getType());
        PropertyBinding<? extends Serializable> binding = new PropertyBinding<Serializable>(propertyConfiguration.getPropertyData(), consumer == null ? null : value -> consumer.accept(this.component, (Serializable)value), selectedStartingValue);
        this.properties.put(propertyConfiguration.getPropertyData().getName(), binding);
    }

    private Serializable jsonValueToConcreteType(JsonValue jsonValue, Class<? extends Serializable> type) {
        Objects.requireNonNull(type, "Parameter 'type' must not be null!");
        if (JsonCodec.canEncodeWithoutTypeInfo(type)) {
            Serializable value = null;
            if (jsonValue != null) {
                value = JsonCodec.decodeAs(jsonValue, type);
            }
            return value;
        }
        throw new IllegalArgumentException(String.format("Received '%s' was not convertible to '%s'", JsonValue.class.getName(), type.getName()));
    }

    private static class PropertyBinding<P extends Serializable>
    implements Serializable {
        private PropertyData<P> data;
        private SerializableConsumer<P> listener;
        private P value;

        PropertyBinding(PropertyData<P> data, SerializableConsumer<P> listener, Serializable startingValue) {
            Objects.requireNonNull(data, "Parameter 'data' must not be null!");
            this.data = data;
            this.listener = listener;
            this.value = startingValue;
        }

        void updateValue(Serializable newValue) {
            if (this.isReadOnly()) {
                LoggerFactory.getLogger(this.getClass()).warn(String.format("An attempt was made to write to a read-only property '%s' owned by exported component %s", this.getName(), this.getType().getCanonicalName()));
                return;
            }
            if (newValue != null && newValue.getClass() != this.getType()) {
                throw new IllegalArgumentException(String.format("Parameter 'newValue' is of the wrong type: onChangeHandler of the property expected to receive %s but found %s instead.", this.getType().getCanonicalName(), newValue.getClass().getCanonicalName()));
            }
            Serializable newTypedValue = newValue;
            if (newTypedValue == null) {
                newTypedValue = this.data.getDefaultValue();
            }
            boolean updated = false;
            if (this.value != null && !this.value.equals(newTypedValue)) {
                updated = true;
            } else if (newValue != null && !newValue.equals(this.value)) {
                updated = true;
            }
            if (updated) {
                this.value = newTypedValue;
                this.notifyValueChange();
            }
        }

        public Class<P> getType() {
            return this.data.getType();
        }

        public String getName() {
            return this.data.getName();
        }

        public P getValue() {
            return this.value;
        }

        public boolean isReadOnly() {
            return this.data.isReadOnly();
        }

        void notifyValueChange() {
            if (this.listener != null) {
                this.listener.accept(this.value);
            }
        }

        public int hashCode() {
            return Objects.hash(this.data, this.value);
        }

        public boolean equals(Object obj) {
            if (obj instanceof PropertyBinding) {
                PropertyBinding other = (PropertyBinding)obj;
                boolean valuesAreNull = this.value == null && other.value == null;
                boolean valuesAreEqual = valuesAreNull || this.value != null && this.value.equals(other.value);
                return this.data.equals(other.data) && valuesAreEqual;
            }
            return false;
        }
    }
}

