/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.ImportExtractor;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;

public class TaskUpdateImports
extends NodeUpdater {
    private final File generatedFlowImports;
    private final File frontendDirectory;
    private static final String IMPORT_TEMPLATE = "import '%s';";
    private static final String THEME_PREPARE = "const div = document.createElement('div');";
    private static final String THEME_LINE_TPL = "div.innerHTML = '%s';%ndocument.head.insertBefore(div.firstElementChild, document.head.firstChild);";
    private static final String THEME_VARIANT_TPL = "document.body.setAttribute('%s', '%s');";
    private static final String CSS_PREPARE = "function addCssBlock(block) {\n const tpl = document.createElement('template');\n tpl.innerHTML = block;\n document.head.appendChild(tpl.content);\n}";
    private static final String CSS_PRE = "import $css_%d from '%s';%naddCssBlock(`";
    private static final String CSS_POST = "`);";
    private static final String CSS_BASIC_TPL = "import $css_%d from '%s';%naddCssBlock(`<custom-style><style%s>${$css_%d}</style></custom-style>`);";
    private static final String CSS_MODULE_TPL = "import $css_%d from '%s';%naddCssBlock(`<dom-module id=\"%s\"><template><style%s>${$css_%d}</style></template></dom-module>`);";
    private static final String CSS_THEME_FOR_TPL = "import $css_%d from '%s';%naddCssBlock(`<dom-module id=\"flow_css_mod_%d\" theme-for=\"%s\"><template><style%s>${$css_%d}</style></template></dom-module>`);";
    private static final Pattern NEW_LINE_TRIM = Pattern.compile("(?m)(^\\s+|\\s?\n)");

    TaskUpdateImports(ClassFinder finder, FrontendDependencies frontendDependencies, File npmFolder, File generatedPath, File frontendDirectory) {
        super(finder, frontendDependencies, npmFolder, generatedPath);
        this.frontendDirectory = frontendDirectory;
        this.generatedFlowImports = new File(generatedPath, "generated-flow-imports.js");
    }

    @Override
    public void execute() {
        LinkedHashSet<String> modules = new LinkedHashSet<String>();
        modules.addAll(this.resolveModules(this.frontDeps.getModules(), true));
        modules.addAll(this.resolveModules(this.frontDeps.getScripts(), false));
        modules.addAll(this.getGeneratedModules(this.generatedFolder, Collections.singleton(this.generatedFlowImports.getName())));
        modules.removeIf(module -> module.contains("://"));
        try {
            this.updateMainJsFile(this.getMainJsContent(modules));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to update the Flow imports file '%s'", this.generatedFlowImports), e);
        }
    }

    private List<String> getMainJsContent(Set<String> modules) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(this.getThemeLines());
        lines.addAll(this.getCssLines());
        lines.addAll(this.getModuleLines(modules));
        return lines;
    }

    private Collection<String> getThemeLines() {
        ArrayList<String> lines = new ArrayList<String>();
        AbstractTheme theme = this.frontDeps.getTheme();
        ThemeDefinition themeDef = this.frontDeps.getThemeDefinition();
        if (theme != null) {
            if (!theme.getHeaderInlineContents().isEmpty()) {
                lines.add(THEME_PREPARE);
                theme.getHeaderInlineContents().forEach(html -> this.addLines(lines, String.format(THEME_LINE_TPL, NEW_LINE_TRIM.matcher((CharSequence)html).replaceAll(""))));
            }
            theme.getHtmlAttributes(themeDef.getVariant()).forEach((key, value) -> this.addLines(lines, String.format(THEME_VARIANT_TPL, key, value)));
            lines.add("");
        }
        return lines;
    }

    private void addLines(Collection<String> lines, String content) {
        lines.addAll(Arrays.asList(content.split("\r?\n")));
    }

    private Collection<String> getCssLines() {
        ArrayList<String> lines = new ArrayList<String>();
        Set<CssData> css = this.frontDeps.getCss();
        if (!css.isEmpty()) {
            this.addLines(lines, CSS_PREPARE);
            HashSet<String> cssNotFound = new HashSet<String>();
            int i = 0;
            for (CssData cssData : css) {
                if (!this.addCssLines(lines, cssData, i)) {
                    cssNotFound.add(cssData.getValue());
                }
                ++i;
            }
            if (!cssNotFound.isEmpty()) {
                throw new IllegalStateException(this.notFoundMessage(cssNotFound, "Failed to find the following css files in the `node_modules` or `/frontend` tree:", "Check that they exist or are installed."));
            }
            lines.add("");
        }
        return lines;
    }

    private boolean addCssLines(Collection<String> lines, CssData cssData, int i) {
        String include;
        String cssFile = this.resolveResource(cssData.getValue(), false);
        boolean found = this.importedFileExists(cssFile);
        String cssImport = this.toValidBrowserImport(cssFile);
        String string = include = cssData.getInclude() != null ? " include=\"" + cssData.getInclude() + "\"" : "";
        if (cssData.getThemefor() != null) {
            this.addLines(lines, String.format(CSS_THEME_FOR_TPL, i, cssImport, i, cssData.getThemefor(), include, i));
        } else if (cssData.getId() != null) {
            this.addLines(lines, String.format(CSS_MODULE_TPL, i, cssImport, cssData.getId(), include, i));
        } else {
            this.addLines(lines, String.format(CSS_BASIC_TPL, i, cssImport, include, i));
        }
        return found;
    }

    private Collection<String> getModuleLines(Set<String> modules) {
        HashSet<String> resourceNotFound = new HashSet<String>();
        HashSet<String> npmNotFound = new HashSet<String>();
        HashSet<String> visited = new HashSet<String>();
        AbstractTheme theme = this.frontDeps.getTheme();
        ArrayList<String> lines = new ArrayList<String>();
        Iterator<String> iterator = modules.iterator();
        while (iterator.hasNext()) {
            String originalModulePath;
            String translatedModulePath = originalModulePath = iterator.next();
            String localModulePath = null;
            if (theme != null && translatedModulePath.contains(theme.getBaseUrl())) {
                translatedModulePath = theme.translateUrl(translatedModulePath);
                String themePath = theme.getThemeUrl();
                localModulePath = translatedModulePath.replaceFirst("@.+" + themePath, themePath);
            }
            if (localModulePath != null && this.frontendFileExists(localModulePath)) {
                lines.add(String.format(IMPORT_TEMPLATE, this.toValidBrowserImport(localModulePath)));
            } else if (this.importedFileExists(translatedModulePath)) {
                lines.add(String.format(IMPORT_TEMPLATE, this.toValidBrowserImport(translatedModulePath)));
            } else if (this.importedFileExists(originalModulePath)) {
                lines.add(String.format(IMPORT_TEMPLATE, this.toValidBrowserImport(originalModulePath)));
            } else if (originalModulePath.startsWith("./")) {
                resourceNotFound.add(originalModulePath);
            } else {
                npmNotFound.add(originalModulePath);
                lines.add(String.format(IMPORT_TEMPLATE, originalModulePath));
            }
            if (theme == null) continue;
            this.handleImports(originalModulePath, theme, lines, visited);
        }
        if (!resourceNotFound.isEmpty()) {
            throw new IllegalStateException(this.notFoundMessage(resourceNotFound, "Failed to resolve the following files either:\n   \u00b7 in the `/frontend` sources folder\n   \u00b7 or as a `META-INF/resources/frontend` resource in some JAR.", "Please, double check that those files exist."));
        }
        if (!npmNotFound.isEmpty() && this.log().isInfoEnabled()) {
            this.log().info(this.notFoundMessage(npmNotFound, "Failed to find the following imports in the `node_modules` tree:", "If the build fails, check that npm packages are installed."));
        }
        return lines;
    }

    private String notFoundMessage(Set<String> files, String prefix, String suffix) {
        return String.format("%n%n  %s%n      - %s%n  %s%n%n", prefix, String.join((CharSequence)"\n      - ", files), suffix);
    }

    private void handleImports(String path, AbstractTheme theme, Collection<String> imports, Set<String> visitedImports) {
        if (visitedImports.contains(path)) {
            return;
        }
        File file = this.getImportedFrontendFile(path);
        if (file == null) {
            return;
        }
        Path filePath = file.toPath();
        visitedImports.add(filePath.normalize().toString());
        try {
            this.visitImportsRecursively(filePath, path, theme, imports, visitedImports);
        }
        catch (IOException exception) {
            LoggerFactory.getLogger(TaskUpdateImports.class).warn("Could not read file {}. Skipping applyig theme for its imports", (Object)file.getPath(), (Object)exception);
        }
    }

    private void visitImportsRecursively(Path filePath, String path, AbstractTheme theme, Collection<String> imports, Set<String> visitedImports) throws IOException {
        String content = Files.readAllLines(filePath, StandardCharsets.UTF_8).stream().collect(Collectors.joining("\n"));
        ImportExtractor extractor = new ImportExtractor(content);
        List<String> importedPaths = extractor.getImportedPaths();
        for (String importedPath : importedPaths) {
            String translatedPath;
            String resolvedPath = this.resolve(importedPath, filePath, path);
            File file = this.getImportedFrontendFile(resolvedPath);
            if (file == null && !importedPath.startsWith("./")) {
                file = this.getFile(this.nodeModulesFolder, resolvedPath);
                resolvedPath = importedPath;
            }
            if (file == null) continue;
            if (resolvedPath.contains(theme.getBaseUrl()) && this.importedFileExists(translatedPath = theme.translateUrl(resolvedPath))) {
                imports.add(String.format(IMPORT_TEMPLATE, this.normalizeImportPath(translatedPath)));
            }
            this.handleImports(resolvedPath, theme, imports, visitedImports);
        }
    }

    private String normalizeImportPath(String path) {
        String importPath = this.toValidBrowserImport(path);
        File file = new File(importPath);
        return file.toPath().normalize().toString();
    }

    private String resolve(String importedPath, Path moduleFile, String path) {
        String pathPrefix = moduleFile.toString();
        pathPrefix = pathPrefix.substring(0, pathPrefix.length() - path.length());
        String resolvedPath = moduleFile.getParent().resolve(importedPath).toString();
        if (resolvedPath.startsWith(pathPrefix)) {
            resolvedPath = resolvedPath.substring(pathPrefix.length());
        }
        return resolvedPath;
    }

    private boolean frontendFileExists(String jsImport) {
        File file = this.getFile(this.frontendDirectory, jsImport);
        return file.exists();
    }

    private boolean importedFileExists(String importName) {
        File file = this.getImportedFrontendFile(importName);
        if (file != null) {
            return true;
        }
        boolean found = this.isFile(this.nodeModulesFolder, importName);
        if (importName.toLowerCase().endsWith(".css")) {
            return found;
        }
        found = found || this.isFile(this.nodeModulesFolder, importName + ".js");
        found = found || this.isFile(this.nodeModulesFolder, importName, "package.json");
        found = found || this.isFile(this.generatedFolder, TaskUpdateImports.generatedResourcePathIntoRelativePath(importName));
        return found;
    }

    private File getImportedFrontendFile(String jsImport) {
        File file = this.getFile(this.frontendDirectory, jsImport);
        if (file.exists()) {
            return file;
        }
        file = this.getFile(this.nodeModulesFolder, "@vaadin/flow-frontend/", jsImport);
        return file.exists() ? file : null;
    }

    private File getFile(File base, String ... path) {
        return new File(base, String.join((CharSequence)"/", path));
    }

    private boolean isFile(File base, String ... path) {
        return this.getFile(base, path).isFile();
    }

    private String toValidBrowserImport(String jsImport) {
        if (jsImport.startsWith("GENERATED/")) {
            return TaskUpdateImports.generatedResourcePathIntoRelativePath(jsImport);
        }
        if (this.isFile(this.frontendDirectory, jsImport)) {
            if (!jsImport.startsWith("./")) {
                this.log().warn("Use the './' prefix for files in the 'frontend' folder: '{}', please update your annotations.", (Object)jsImport);
            }
            return "Frontend/" + jsImport.replaceFirst("^\\./", "");
        }
        return jsImport;
    }

    private void updateMainJsFile(List<String> newContent) throws IOException {
        List oldContent;
        List list = oldContent = this.generatedFlowImports.exists() ? FileUtils.readLines((File)this.generatedFlowImports, (String)"UTF-8") : null;
        if (newContent.equals(oldContent)) {
            this.log().info("No js modules to update");
        } else {
            FileUtils.forceMkdir((File)this.generatedFlowImports.getParentFile());
            FileUtils.writeStringToFile((File)this.generatedFlowImports, (String)String.join((CharSequence)"\n", newContent), (String)"UTF-8");
            this.log().info("Updated {}", (Object)this.generatedFlowImports);
        }
    }

    private static String generatedResourcePathIntoRelativePath(String path) {
        return path.replace("GENERATED/", "./");
    }
}

