/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.DevModeHandler;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.frontend.NodeTasks;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.startup.ServletDeployer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.annotation.WebListener;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HandlesTypes(value={Route.class, NpmPackage.class, NpmPackage.Container.class, WebComponentExporter.class})
@WebListener
public class DevModeInitializer
implements ServletContainerInitializer,
Serializable,
ServletContextListener {
    private static final Pattern JAR_FILE_REGEX = Pattern.compile(".*file:(.+\\.jar).*");

    public void onStartup(Set<Class<?>> classes, ServletContext context) throws ServletException {
        Collection registrations = context.getServletRegistrations().values();
        if (registrations.isEmpty()) {
            return;
        }
        DeploymentConfiguration config = ServletDeployer.StubServletConfig.createDeploymentConfiguration(context, (ServletRegistration)registrations.iterator().next(), VaadinServlet.class);
        DevModeInitializer.initDevModeHandler(classes, context, config);
    }

    public static void initDevModeHandler(Set<Class<?>> classes, ServletContext context, DeploymentConfiguration config) {
        if (config.isProductionMode()) {
            DevModeInitializer.log().debug("Skipping DEV MODE because PRODUCTION MODE is set.");
            return;
        }
        if (config.isCompatibilityMode()) {
            DevModeInitializer.log().debug("Skipping DEV MODE because BOWER MODE is set.");
            return;
        }
        if (!config.enableDevServer()) {
            DevModeInitializer.log().debug("Skipping DEV MODE because dev server shouldn't be enabled.");
            return;
        }
        String baseDir = config.getStringProperty("project.basedir", System.getProperty("user.dir", "."));
        Set<File> jarFiles = DevModeInitializer.getJarFilesFromClassloader();
        NodeTasks.Builder builder = new NodeTasks.Builder(new ClassFinder.DefaultClassFinder(classes), new File(baseDir));
        DevModeInitializer.log().info("Starting dev-mode updaters in {} folder.", (Object)builder.npmFolder);
        if (!builder.generatedFolder.exists()) {
            try {
                FileUtils.forceMkdir((File)builder.generatedFolder);
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Failed to create directory '%s'", builder.generatedFolder), e);
            }
        }
        File generatedPackages = new File(builder.generatedFolder, "package.json");
        if (!new File(builder.npmFolder, "webpack.generated.js").exists()) {
            builder.withWebpack(builder.npmFolder, "webpack.config.js", "webpack.generated.js");
        }
        if (!new File(builder.npmFolder, "package.json").exists() || !generatedPackages.exists()) {
            builder.createMissingPackageJson(true);
        }
        HashSet<String> visitedClassNames = new HashSet<String>();
        builder.enablePackagesUpdate(true).copyResources(jarFiles).enableImportsUpdate(true).runNpmInstall(true).withEmbeddableWebComponents(true).collectVisitedClasses(visitedClassNames).build().execute();
        VaadinServletContext vaadinContext = new VaadinServletContext(context);
        vaadinContext.setAttribute(new VisitedClasses(visitedClassNames));
        DevModeHandler.start(config, builder.npmFolder);
    }

    private static Logger log() {
        return LoggerFactory.getLogger(DevModeInitializer.class);
    }

    public void contextInitialized(ServletContextEvent ctx) {
    }

    public void contextDestroyed(ServletContextEvent ctx) {
        DevModeHandler handler = DevModeHandler.getDevModeHandler();
        if (handler != null && !handler.reuseDevServer()) {
            handler.stop();
        }
    }

    private static Set<File> getJarFilesFromClassloader() {
        HashSet<File> jarFiles = new HashSet<File>();
        try {
            Enumeration<URL> en = DevModeInitializer.class.getClassLoader().getResources("META-INF/resources/frontend");
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                Matcher matcher = JAR_FILE_REGEX.matcher(url.getPath());
                if (!matcher.find()) continue;
                jarFiles.add(new File(matcher.group(1)));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return jarFiles;
    }

    public static class VisitedClasses
    implements Serializable {
        private Set<String> visitedClassNames;

        public VisitedClasses(Set<String> visitedClassNames) {
            assert (visitedClassNames != null);
            this.visitedClassNames = visitedClassNames;
        }

        public boolean allDependenciesVisited(Class<?> dependencyClass) {
            if (this.visitedClassNames.contains(dependencyClass.getName())) {
                return true;
            }
            if (((JsModule[])dependencyClass.getDeclaredAnnotationsByType(JsModule.class)).length != 0) {
                return false;
            }
            Class<?> superclass = dependencyClass.getSuperclass();
            if (superclass == null) {
                return true;
            }
            return this.allDependenciesVisited(superclass);
        }

        public void ensureAllDependenciesVisited(Class<?> clazz) {
            if (!this.allDependenciesVisited(clazz)) {
                DevModeInitializer.log().warn("Frontend dependencies have not been analyzed for {}. To make the component's frontend dependencies work, you must ensure the component class is directly referenced through an application entry point such as a class annotated with @Route.", (Object)clazz.getName());
            }
        }
    }
}

