/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeEvent;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.shared.util.SharedUtil;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class AbstractSinglePropertyField<C extends AbstractField<C, T>, T>
extends AbstractField<C, T> {
    private static final SerializableBiFunction RAW_IDENTITY = (ignore, value) -> value;
    private static final SerializableBiFunction RAW_NON_NULL_IDENTITY = (ignore, value) -> Objects.requireNonNull(value, "Null value is not supported");
    private static final Map<Class<?>, TypeHandler<?>> typeHandlers = new HashMap();
    private final SerializableBiConsumer<C, T> propertyWriter;
    private final SerializableBiFunction<C, T, T> propertyReader;
    private final String propertyName;
    private DomListenerRegistration synchronizationRegistration;

    public AbstractSinglePropertyField(String propertyName, T defaultValue, boolean acceptNullValues) {
        this(propertyName, defaultValue, null, RAW_IDENTITY, acceptNullValues ? RAW_IDENTITY : RAW_NON_NULL_IDENTITY);
    }

    public <P> AbstractSinglePropertyField(String propertyName, T defaultValue, Class<P> elementPropertyType, SerializableFunction<P, T> presentationToModel, SerializableFunction<T, P> modelToPresentation) {
        this(propertyName, defaultValue, elementPropertyType, (ignore, value) -> presentationToModel.apply(value), (ignore, value) -> modelToPresentation.apply(value));
    }

    public <P> AbstractSinglePropertyField(String propertyName, T defaultValue, Class<P> elementPropertyType, SerializableBiFunction<C, P, T> presentationToModel, SerializableBiFunction<C, T, P> modelToPresentation) {
        super(defaultValue);
        this.propertyName = propertyName;
        if (elementPropertyType == null) {
            if (presentationToModel == RAW_IDENTITY) {
                elementPropertyType = AbstractSinglePropertyField.findElementPropertyTypeFromTypeParameter(this.getClass());
                if (elementPropertyType == null) {
                    throw new IllegalStateException("Cannot automatically determine element property type based on type parameters.");
                }
            } else {
                throw new IllegalArgumentException("Element property type cannot be null");
            }
        }
        TypeHandler<P> typeHandler = this.findHandler(elementPropertyType);
        Element element = this.getElement();
        this.propertyWriter = ((TypeHandler)typeHandler).createWriter(element, propertyName, modelToPresentation);
        this.propertyReader = ((TypeHandler)typeHandler).createReader(element, propertyName, presentationToModel);
        this.doSetSynchronizedEvent(SharedUtil.camelCaseToDashSeparated(propertyName) + "-changed");
    }

    private <P> TypeHandler<P> findHandler(Class<P> clazz) {
        TypeHandler<Object> typeHandler = typeHandlers.get(clazz);
        if (typeHandler == null && JsonValue.class.isAssignableFrom(clazz)) {
            typeHandler = AbstractSinglePropertyField.getHandler(clazz);
        }
        if (typeHandler == null) {
            throw new IllegalArgumentException("Unsupported element property type: " + clazz.getName() + ". Supported types are: " + typeHandlers.keySet().parallelStream().map(Class::getName).collect(Collectors.joining(", ")));
        }
        return typeHandler;
    }

    private static <T> Class<T> findElementPropertyTypeFromTypeParameter(Class<?> hasValueClass) {
        return GenericTypeReflector.erase((Type)GenericTypeReflector.getTypeParameter(hasValueClass, HasValue.class.getTypeParameters()[1]));
    }

    protected void setSynchronizedEvent(String synchronizedEvent) {
        this.doSetSynchronizedEvent(synchronizedEvent);
    }

    protected DomListenerRegistration getSynchronizationRegistration() {
        return this.synchronizationRegistration;
    }

    private void doSetSynchronizedEvent(String propChangeEvent) {
        if (this.synchronizationRegistration != null) {
            this.synchronizationRegistration.remove();
        }
        this.synchronizationRegistration = propChangeEvent != null ? this.getElement().addPropertyChangeListener(this.propertyName, propChangeEvent, this::handlePropertyChange) : null;
    }

    protected boolean hasValidValue() {
        return true;
    }

    private void handlePropertyChange(PropertyChangeEvent event) {
        if (this.hasValidValue()) {
            Object presentationValue = this.propertyReader.apply((C)this, (AbstractSinglePropertyField)this.getEmptyValue());
            this.setModelValue(presentationValue, event.isUserOriginated());
        }
    }

    @Override
    protected void setPresentationValue(T newPresentationValue) {
        this.propertyWriter.accept((C)this, (AbstractSinglePropertyField)newPresentationValue);
    }

    private static <P extends JsonValue> TypeHandler<P> getHandler(Class<P> type) {
        ElementGetter<JsonValue> getter = (element, property, defaultValue) -> {
            Serializable value = element.getPropertyRaw(property);
            return (JsonValue)type.cast(JsonCodec.encodeWithoutTypeInfo(value));
        };
        ElementSetter<JsonValue> setter = (element, property, value) -> element.setPropertyJson(property, (JsonValue)value);
        return new TypeHandler(setter, getter, null);
    }

    private static <T> void addHandler(ElementSetter<T> setter, ElementGetter<T> getter, Class<T> type, T typeDefaultValue) {
        typeHandlers.put(type, new TypeHandler(setter, getter, typeDefaultValue));
    }

    static {
        AbstractSinglePropertyField.addHandler(Element::setProperty, Element::getProperty, String.class, "");
        AbstractSinglePropertyField.addHandler(Element::setProperty, Element::getProperty, Double.class, 0.0);
        AbstractSinglePropertyField.addHandler(Element::setProperty, Element::getProperty, Boolean.class, Boolean.FALSE);
        AbstractSinglePropertyField.addHandler(Element::setProperty, Element::getProperty, Integer.class, 0);
        typeHandlers.put(JsonValue.class, AbstractSinglePropertyField.getHandler(JsonValue.class));
    }

    private static class TypeHandler<P>
    implements Serializable {
        private final ElementSetter<P> setter;
        private final SerializableBiFunction<Element, String, P> getter;

        private TypeHandler(ElementSetter<P> setter, ElementGetter<P> getter, P typeDefault) {
            this.setter = setter;
            this.getter = (element, propertyName) -> getter.getValue((Element)element, (String)propertyName, typeDefault);
        }

        private <C extends AbstractField<C, V>, V> SerializableBiFunction<C, V, V> createReader(Element element, String propertyName, SerializableBiFunction<C, P, V> presentationToModel) {
            return (component, defaultModelValue) -> {
                if (element.getPropertyRaw(propertyName) != null) {
                    Object presentationValue = this.getter.apply(element, propertyName);
                    return presentationToModel.apply(component, presentationValue);
                }
                return defaultModelValue;
            };
        }

        private <C extends AbstractField<C, V>, V> SerializableBiConsumer<C, V> createWriter(Element element, String propertyName, SerializableBiFunction<C, V, P> modelToPresentation) {
            return (component, modelValue) -> {
                Object presentationValue = modelToPresentation.apply(component, modelValue);
                if (presentationValue == null) {
                    element.removeProperty(propertyName);
                } else {
                    this.setter.setElementValue(element, propertyName, presentationValue);
                }
            };
        }
    }

    @FunctionalInterface
    private static interface ElementGetter<T>
    extends Serializable {
        public T getValue(Element var1, String var2, T var3);
    }

    @FunctionalInterface
    private static interface ElementSetter<T>
    extends Serializable {
        public void setElementValue(Element var1, String var2, T var3);
    }
}

