/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeUpdater;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class TaskRunNpmInstall
implements Command {
    private final NodeUpdater packageUpdater;

    TaskRunNpmInstall(NodeUpdater packageUpdater) {
        this.packageUpdater = packageUpdater;
    }

    @Override
    public void execute() {
        if (this.packageUpdater.modified || this.shouldRunNpmInstall()) {
            NodeUpdater.log().info("Running `npm install` ...");
            this.runNpmInstall();
        } else {
            NodeUpdater.log().info("Skipping `npm install`.");
        }
    }

    private boolean shouldRunNpmInstall() {
        if (this.packageUpdater.nodeModulesFolder.isDirectory()) {
            File[] installedPackages = this.packageUpdater.nodeModulesFolder.listFiles();
            return installedPackages == null || installedPackages.length == 1 && "@vaadin/flow-frontend/".startsWith(installedPackages[0].getName());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNpmInstall() {
        ArrayList<String> command = new ArrayList<String>(FrontendUtils.getNpmExecutable(this.packageUpdater.npmFolder.getAbsolutePath()));
        command.add("install");
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        builder.environment().put("ADBLOCK", "1");
        builder.directory(this.packageUpdater.npmFolder);
        Process process = null;
        try {
            process = builder.inheritIO().start();
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                NodeUpdater.log().error(">>> Dependency ERROR. Check that all required dependencies are deployed in npm repositories.");
            } else {
                NodeUpdater.log().info("package.json updated and npm dependencies installed. ");
            }
        }
        catch (IOException | InterruptedException e) {
            NodeUpdater.log().error("Error when running `npm install`", (Throwable)e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }
}

