/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DevModeHandler
implements Serializable {
    private static AtomicReference<DevModeHandler> atomicHandler = new AtomicReference();
    private static final String DEFAULT_OUTPUT_PATTERN = ": Compiled.";
    private static final String DEFAULT_ERROR_PATTERN = ": Failed to compile.";
    private static final String FAILED_MSG = "\n------------------ Frontend compilation failed. -----------------";
    private static final String SUCCEED_MSG = "\n----------------- Frontend compiled successfully. -----------------";
    private static final String YELLOW = "\u001b[38;5;111m{}\u001b[0m";
    private static final String RED = "\u001b[38;5;196m{}\u001b[0m";
    private static final String GREEN = "\u001b[38;5;35m{}\u001b[0m";
    private static final String DEFAULT_TIMEOUT_FOR_PATTERN = "60000";
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final int DEFAULT_TIMEOUT = 120000;
    private static final String WEBPACK_HOST = "http://localhost";
    private boolean notified = false;
    private String failedOutput;
    public static final String WEBPACK_SERVER = "node_modules/webpack-dev-server/bin/webpack-dev-server.js";
    private int port;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DevModeHandler(DeploymentConfiguration config, int runningPort, File npmFolder, File webpack, File webpackConfig) {
        this.port = runningPort;
        if (this.port > 0) {
            if (this.checkWebpackConnection()) {
                DevModeHandler.getLogger().info("Webpack is running at {}:{}", (Object)WEBPACK_HOST, (Object)this.port);
                return;
            }
            throw new IllegalStateException(String.format("webpack server port '%d' is defined but it's not working properly", this.port));
        }
        this.port = DevModeHandler.getFreePort();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).directory(npmFolder);
        FrontendUtils.validateNodeAndNpmVersion(npmFolder.getAbsolutePath());
        ArrayList<String> command = new ArrayList<String>();
        command.add(FrontendUtils.getNodeExecutable(npmFolder.getAbsolutePath()));
        command.add(webpack.getAbsolutePath());
        command.add("--config");
        command.add(webpackConfig.getAbsolutePath());
        command.add("--port");
        command.add(String.valueOf(this.port));
        command.addAll(Arrays.asList(config.getStringProperty("devmode.webpack.options", "-d --inline=false").split(" +")));
        if (DevModeHandler.getLogger().isInfoEnabled()) {
            DevModeHandler.getLogger().info("Starting Webpack in dev mode, port: {} dir: {}\n   {}", new Object[]{this.port, npmFolder, String.join((CharSequence)" ", command)});
        }
        processBuilder.command(command);
        try {
            Process webpackProcess = processBuilder.redirectError(ProcessBuilder.Redirect.PIPE).redirectErrorStream(true).start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                webpackProcess.destroy();
                this.removeRunningDevServerPort();
            }));
            Pattern succeed = Pattern.compile(config.getStringProperty("devmode.webpack.output.success.pattern", DEFAULT_OUTPUT_PATTERN));
            Pattern failure = Pattern.compile(config.getStringProperty("devmode.webpack.output.error.pattern", DEFAULT_ERROR_PATTERN));
            this.logStream(webpackProcess.getInputStream(), succeed, failure);
            DevModeHandler devModeHandler = this;
            synchronized (devModeHandler) {
                this.wait(Integer.parseInt(config.getStringProperty("devmode.webpack.output.pattern.timeout", DEFAULT_TIMEOUT_FOR_PATTERN)));
            }
            if (!webpackProcess.isAlive()) {
                throw new IllegalStateException("Webpack exited prematurely");
            }
        }
        catch (IOException | InterruptedException e) {
            DevModeHandler.getLogger().error("Failed to start the webpack process", (Throwable)e);
        }
        this.saveRunningDevServerPort();
    }

    public static DevModeHandler start(DeploymentConfiguration configuration, File npmFolder) {
        return DevModeHandler.start(0, configuration, npmFolder);
    }

    public static DevModeHandler start(int runningPort, DeploymentConfiguration configuration, File npmFolder) {
        if (configuration.isProductionMode() || configuration.isCompatibilityMode() || !configuration.enableDevServer()) {
            return null;
        }
        atomicHandler.compareAndSet(null, DevModeHandler.createInstance(runningPort, configuration, npmFolder));
        return DevModeHandler.getDevModeHandler();
    }

    public static DevModeHandler getDevModeHandler() {
        return atomicHandler.get();
    }

    private static DevModeHandler createInstance(int runningPort, DeploymentConfiguration configuration, File npmFolder) {
        File webpack = null;
        File webpackConfig = null;
        if (runningPort == 0) {
            runningPort = DevModeHandler.getRunningDevServerPort();
        }
        if (runningPort == 0) {
            webpack = new File(npmFolder, WEBPACK_SERVER);
            webpackConfig = new File(npmFolder, "webpack.config.js");
            if (!npmFolder.exists()) {
                DevModeHandler.getLogger().warn("Instance not created because cannot change to '{}'", (Object)npmFolder);
                return null;
            }
            if (!webpack.canExecute()) {
                DevModeHandler.getLogger().warn("Instance not created because cannot execute '{}'. Did you run `npm install`", (Object)webpack);
                return null;
            }
            if (!webpack.exists()) {
                DevModeHandler.getLogger().warn("Instance not created because file '{}' doesn't exist. Did you run `npm install`", (Object)webpack);
                return null;
            }
            if (!webpackConfig.canRead()) {
                DevModeHandler.getLogger().warn("Instance not created because there is not webpack configuration '{}'", (Object)webpackConfig);
                return null;
            }
        }
        return new DevModeHandler(configuration, runningPort, npmFolder, webpack, webpackConfig);
    }

    public boolean isDevModeRequest(HttpServletRequest request) {
        return request.getPathInfo() != null && request.getPathInfo().matches(".+\\.js");
    }

    public boolean serveDevModeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestFilename = request.getPathInfo().replace("VAADIN/", "");
        HttpURLConnection connection = this.prepareConnection(requestFilename, request.getMethod());
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header2;
            connection.setRequestProperty(header2, "Connect".equals(header2 = (String)headerNames.nextElement()) ? "close" : request.getHeader(header2));
        }
        DevModeHandler.getLogger().debug("Requesting resource to webpack {}", (Object)connection.getURL());
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            DevModeHandler.getLogger().debug("Resource not served by webpack {}", (Object)requestFilename);
            return false;
        }
        DevModeHandler.getLogger().debug("Served resource by webpack: {} {}", (Object)responseCode, (Object)requestFilename);
        connection.getHeaderFields().forEach((header, values) -> {
            if (header != null) {
                response.addHeader(header, (String)values.get(0));
            }
        });
        if (responseCode == 200) {
            this.writeStream(response.getOutputStream(), connection.getInputStream());
        } else {
            response.sendError(responseCode);
        }
        response.getOutputStream().close();
        return true;
    }

    private boolean checkWebpackConnection() {
        try {
            this.prepareConnection("/", "GET").getResponseCode();
            return true;
        }
        catch (IOException e) {
            DevModeHandler.getLogger().debug("Error checking webpack dev server connection", (Throwable)e);
            return false;
        }
    }

    public HttpURLConnection prepareConnection(String path, String method) throws IOException {
        URL uri = new URL("http://localhost:" + this.port + path);
        HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
        connection.setRequestMethod(method);
        connection.setReadTimeout(120000);
        connection.setConnectTimeout(120000);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotify() {
        if (!this.notified) {
            this.notified = true;
            DevModeHandler devModeHandler = this;
            synchronized (devModeHandler) {
                this.notify();
            }
        }
    }

    private void logStream(InputStream input, Pattern success, Pattern failure) {
        Thread thread = new Thread(() -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            try {
                this.readLinesLoop(success, failure, reader);
            }
            catch (IOException e) {
                DevModeHandler.getLogger().error("Exception when reading webpack output.", (Throwable)e);
            }
            this.doNotify();
        });
        thread.setName("webpack");
        thread.start();
    }

    private void readLinesLoop(Pattern success, Pattern failure, BufferedReader reader) throws IOException {
        String line;
        StringBuilder output = new StringBuilder();
        Consumer<String> info = s -> DevModeHandler.getLogger().info(GREEN, s);
        Consumer<String> error = s -> DevModeHandler.getLogger().error(RED, s);
        Consumer<String> warn = s -> DevModeHandler.getLogger().warn(YELLOW, s);
        Consumer<String> log = info;
        while ((line = reader.readLine()) != null) {
            String cleanLine = line.replaceAll("\u001b\\[[;\\d]*m", "").replaceAll("\\?babel-target=[\\w\\d]+", "");
            log = line.contains("WARNING") ? warn : (line.contains("ERROR") ? error : log);
            log.accept(cleanLine);
            output.append(cleanLine).append('\n');
            boolean succeed = success.matcher(line).find();
            boolean failed = failure.matcher(line).find();
            if (!succeed && !failed) continue;
            log.accept(succeed ? SUCCEED_MSG : FAILED_MSG);
            this.failedOutput = failed ? output.toString() : null;
            output = new StringBuilder();
            log = info;
            this.doNotify();
        }
    }

    private void writeStream(ServletOutputStream outputStream, InputStream inputStream) throws IOException {
        int bytes;
        byte[] buffer = new byte[32768];
        while ((bytes = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, bytes);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)"dev-webpack");
    }

    public String getFailedOutput() {
        return this.failedOutput;
    }

    public void removeRunningDevServerPort() {
        FileUtils.deleteQuietly((File)DevModeHandler.computeDevServerPortFileName());
    }

    private void saveRunningDevServerPort() {
        File portFile = DevModeHandler.computeDevServerPortFileName();
        try {
            FileUtils.forceMkdir((File)portFile.getParentFile());
            FileUtils.writeStringToFile((File)portFile, (String)String.valueOf(this.port), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static int getRunningDevServerPort() {
        int port = 0;
        File portFile = DevModeHandler.computeDevServerPortFileName();
        if (portFile.canRead()) {
            try {
                String portString = FileUtils.readFileToString((File)portFile, (String)"UTF-8").trim();
                port = Integer.parseInt(portString);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return port;
    }

    private static File computeDevServerPortFileName() {
        String threadGroup = String.valueOf(Thread.currentThread().getThreadGroup().hashCode());
        String jvmUniqueName = ManagementFactory.getRuntimeMXBean().getName();
        String uniqueUid = UUID.nameUUIDFromBytes((jvmUniqueName + threadGroup).getBytes(StandardCharsets.UTF_8)).toString();
        return new File(System.getProperty("java.io.tmpdir"), uniqueUid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getFreePort() {
        try (ServerSocket s = new ServerSocket(0);){
            s.setReuseAddress(true);
            int n = s.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to find a free port for running webpack", e);
        }
    }

    public int getPort() {
        return this.port;
    }
}

