/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;

public class DependencyTreeCache<T>
implements Serializable {
    private final ConcurrentHashMap<T, Object> cache = new ConcurrentHashMap();
    private final SerializableFunction<T, Collection<T>> dependencyParser;

    public DependencyTreeCache(SerializableFunction<T, Collection<T>> dependencyParser) {
        this.dependencyParser = dependencyParser;
    }

    public Set<T> getDependencies(T node) {
        HashSet result = new HashSet();
        LinkedList<T> pendingKeys = new LinkedList<T>();
        pendingKeys.add(node);
        try {
            while (!pendingKeys.isEmpty()) {
                Object path = pendingKeys.removeLast();
                if (!result.add(path)) continue;
                this.getOrParseDependencies(path).forEach(pendingKeys::add);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrputed while finding dependencies for " + node, e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<T> getOrParseDependencies(T node) throws InterruptedException {
        Object placeholder = new Object();
        Object valueOrPlaceholder = this.cache.putIfAbsent(node, placeholder);
        if (valueOrPlaceholder instanceof Collection) {
            Collection dependencies = (Collection)valueOrPlaceholder;
            return dependencies;
        }
        if (valueOrPlaceholder == null) {
            Collection dependencies = (Collection)this.dependencyParser.apply(node);
            this.cache.put(node, dependencies);
            Object object = placeholder;
            synchronized (object) {
                placeholder.notifyAll();
            }
            return dependencies;
        }
        return this.waitForDependencies(node, valueOrPlaceholder);
    }

    private Collection<T> waitForDependencies(T node, Object placeholder) throws InterruptedException {
        Object object = placeholder;
        synchronized (object) {
            while (true) {
                Object valueOrPlaceholder;
                if ((valueOrPlaceholder = this.cache.get(node)) == null) {
                    return this.getOrParseDependencies(node);
                }
                if (valueOrPlaceholder != placeholder) {
                    Collection dependencies = (Collection)valueOrPlaceholder;
                    ArrayList shuffledDependencies = new ArrayList(dependencies);
                    Collections.shuffle(shuffledDependencies, ThreadLocalRandom.current());
                    return shuffledDependencies;
                }
                placeholder.wait();
            }
        }
    }

    public void clear() {
        this.cache.clear();
    }
}

