/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.ThemeData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class EndPointData
implements Serializable {
    final String name;
    String route = "";
    String layout;
    ThemeData theme = new ThemeData();
    final LinkedHashSet<String> modules = new LinkedHashSet();
    final LinkedHashSet<String> themeModules = new LinkedHashSet();
    final LinkedHashSet<String> scripts = new LinkedHashSet();
    final transient List<CssData> css = new ArrayList<CssData>();
    private final HashSet<String> classes = new HashSet();

    EndPointData(Class<?> clazz) {
        this.name = clazz.getName();
    }

    public String toString() {
        return String.format("%n view: %s%n route: %s%n%s%n layout: %s%n modules: %s%n scripts: %s%n css: %s%n", this.name, this.route, this.theme, this.layout, this.col2Str(this.modules), this.col2Str(this.scripts), this.col2Str(this.css));
    }

    LinkedHashSet<String> getModules() {
        return this.modules;
    }

    LinkedHashSet<String> getThemeModules() {
        return this.themeModules;
    }

    LinkedHashSet<String> getScripts() {
        return this.scripts;
    }

    Set<String> getClasses() {
        return this.classes;
    }

    ThemeData getTheme() {
        return this.theme;
    }

    String getRoute() {
        return this.route;
    }

    String getLayout() {
        return this.layout;
    }

    String getName() {
        return this.name;
    }

    Set<CssData> getCss() {
        return this.css.stream().collect(Collectors.toSet());
    }

    private String col2Str(Collection<?> s) {
        return String.join((CharSequence)"\n          ", String.valueOf(s));
    }
}

