/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.ClassFinder;
import com.vaadin.flow.server.frontend.FrontendDependencies;
import com.vaadin.flow.server.frontend.NodeUpdater;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;

public class TaskUpdatePackages
extends NodeUpdater {
    TaskUpdatePackages(ClassFinder finder, FrontendDependencies frontendDependencies, File npmFolder, File generatedPath) {
        super(finder, frontendDependencies, npmFolder, generatedPath);
    }

    @Override
    public void execute() {
        try {
            Map<String, String> deps = this.frontDeps.getPackages();
            JsonObject packageJson = this.getAppPackageJson();
            if (packageJson == null) {
                packageJson = Json.createObject();
            }
            this.modified = this.updatePackageJsonDependencies(packageJson, deps);
            if (this.modified) {
                this.writeAppPackageFile(packageJson);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean updatePackageJsonDependencies(JsonObject packageJson, Map<String, String> deps) {
        boolean added = false;
        for (Map.Entry<String, String> dep : deps.entrySet()) {
            added = this.addDependency(packageJson, "dependencies", dep.getKey(), dep.getValue()) || added;
        }
        JsonObject dependencies = packageJson.getObject("dependencies");
        if (dependencies != null) {
            for (String key : dependencies.keys()) {
                if (deps.containsKey(key)) continue;
                dependencies.remove(key);
            }
        }
        return added;
    }
}

