/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.StyleSheet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class AnnotationReader {
    private AnnotationReader() {
    }

    public static List<StyleSheet> getStyleSheetAnnotations(Class<? extends Component> componentClass) {
        return AnnotationReader.getAnnotationsFor(componentClass, StyleSheet.class);
    }

    public static List<JavaScript> getJavaScriptAnnotations(Class<? extends Component> componentClass) {
        return AnnotationReader.getAnnotationsFor(componentClass, JavaScript.class);
    }

    public static List<JsModule> getJsModuleAnnotations(Class<? extends Component> componentClass) {
        return AnnotationReader.getAnnotationsFor(componentClass, JsModule.class);
    }

    public static List<HtmlImport> getHtmlImportAnnotations(Class<? extends Component> componentClass) {
        return AnnotationReader.getAnnotationsFor(componentClass, HtmlImport.class);
    }

    public static <T extends Annotation> Optional<T> getAnnotationFor(Field field, Class<T> annotationType) {
        T annotation = field.getAnnotation(annotationType);
        return Optional.ofNullable(annotation);
    }

    public static <T extends Annotation> Optional<T> getAnnotationFor(Class<?> clazz, Class<T> annotationType) {
        T annotation;
        for (Class<?> currentType = clazz; currentType != null && currentType != Object.class; currentType = currentType.getSuperclass()) {
            annotation = currentType.getAnnotation(annotationType);
            if (annotation == null) continue;
            return Optional.of(annotation);
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            annotation = iface.getAnnotation(annotationType);
            if (annotation == null) continue;
            return Optional.of(annotation);
        }
        return Optional.empty();
    }

    public static <A extends Annotation, T> Optional<T> getAnnotationValueFor(Class<?> clazz, Class<A> annotationType, Function<A, T> valueExtractor) {
        return AnnotationReader.getAnnotationFor(clazz, annotationType).map(valueExtractor);
    }

    public static <T extends Annotation> List<T> getAnnotationsFor(Class<?> clazz, Class<T> annotationType) {
        if (clazz == null || clazz == Object.class) {
            return Collections.emptyList();
        }
        ArrayList<Object> annotations = new ArrayList<Object>();
        annotations.addAll(AnnotationReader.getAnnotationsFor(clazz.getSuperclass(), annotationType));
        for (Class<?> iface : clazz.getInterfaces()) {
            annotations.addAll(AnnotationReader.getAnnotationsFor(iface, annotationType));
        }
        for (Annotation annotation : clazz.getAnnotationsByType(annotationType)) {
            if (annotation == null) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    public static <A extends Annotation, T> Stream<T> getAnnotationValuesFor(Class<?> clazz, Class<A> annotationType, Function<A, T> valueExtractor) {
        return AnnotationReader.getAnnotationsFor(clazz, annotationType).stream().map(valueExtractor);
    }
}

