/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.theme;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface AbstractTheme
extends Serializable {
    public String getBaseUrl();

    public String getThemeUrl();

    default public List<String> getHeaderInlineContents() {
        return Collections.emptyList();
    }

    default public Map<String, String> getBodyAttributes(String variant) {
        return Collections.emptyMap();
    }

    default public String translateUrl(String url) {
        if (url.contains(this.getBaseUrl())) {
            String baseUrl = this.getBaseUrl();
            String themeUrl = this.getThemeUrl();
            if (baseUrl.endsWith("/") && !themeUrl.endsWith("/")) {
                themeUrl = themeUrl + "/";
            } else if (!baseUrl.endsWith("/") && themeUrl.endsWith("/")) {
                themeUrl = themeUrl.substring(0, themeUrl.length() - 1);
            }
            int start = url.lastIndexOf(baseUrl);
            StringBuilder builder = new StringBuilder();
            builder.append(url.substring(0, start));
            builder.append(themeUrl);
            builder.append(url.substring(start + baseUrl.length()));
            return builder.toString();
        }
        return url;
    }
}

