/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.DeploymentConfigurationFactory;
import com.vaadin.flow.server.FrontendVaadinServlet;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Optional;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletDeployer
implements ServletContextListener {
    private static final String SKIPPING_AUTOMATIC_SERVLET_REGISTRATION_BECAUSE = "Skipping automatic servlet registration because";

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        Collection<DeploymentConfiguration> servletConfigurations = this.getServletConfigurations(context);
        boolean enableServlets = true;
        boolean hasDevelopmentMode = servletConfigurations.isEmpty();
        for (DeploymentConfiguration configuration : servletConfigurations) {
            enableServlets = enableServlets && !configuration.disableAutomaticServletRegistration();
            boolean devMode = !configuration.useCompiledFrontendResources();
            hasDevelopmentMode = hasDevelopmentMode || devMode;
        }
        if (enableServlets && this.createAppServlet(context) == VaadinServletCreation.SERVLET_EXISTS && hasDevelopmentMode) {
            this.createServletIfNotExists(context, "frontendFilesServlet", FrontendVaadinServlet.class, "/frontend/*");
        }
    }

    private Collection<DeploymentConfiguration> getServletConfigurations(ServletContext context) {
        Collection registrations = context.getServletRegistrations().values();
        ArrayList<DeploymentConfiguration> result = new ArrayList<DeploymentConfiguration>(registrations.size());
        for (ServletRegistration registration : registrations) {
            this.loadClass(context.getClassLoader(), registration.getClassName()).ifPresent(servletClass -> result.add(StubServletConfig.createDeploymentConfiguration(context, registration, servletClass)));
        }
        return result;
    }

    private VaadinServletCreation createAppServlet(ServletContext context) {
        boolean createServlet = ApplicationRouteRegistry.getInstance(context).hasNavigationTargets();
        if (!createServlet) {
            ServletDeployer.getLogger().info("{} there are no navigation targets registered to the route registry and there are no web component exporters", (Object)SKIPPING_AUTOMATIC_SERVLET_REGISTRATION_BECAUSE);
            return VaadinServletCreation.NO_CREATION;
        }
        ServletRegistration vaadinServlet = this.findVaadinServlet(context);
        if (vaadinServlet != null) {
            ServletDeployer.getLogger().info("{} there is already a Vaadin servlet with the name {}", (Object)SKIPPING_AUTOMATIC_SERVLET_REGISTRATION_BECAUSE, (Object)vaadinServlet.getName());
            return VaadinServletCreation.SERVLET_EXISTS;
        }
        return this.createServletIfNotExists(context, this.getClass().getName(), VaadinServlet.class, "/*");
    }

    private VaadinServletCreation createServletIfNotExists(ServletContext context, String name, Class<? extends Servlet> servletClass, String path) {
        ServletRegistration existingServlet = this.findServletByPathPart(context, path);
        if (existingServlet != null) {
            ServletDeployer.getLogger().info("{} there is already a {} servlet with the name {} for path {} given", new Object[]{SKIPPING_AUTOMATIC_SERVLET_REGISTRATION_BECAUSE, existingServlet, existingServlet.getName(), path});
            return VaadinServletCreation.SERVLET_EXISTS;
        }
        ServletRegistration.Dynamic registration = context.addServlet(name, servletClass);
        if (registration == null) {
            ServletDeployer.getLogger().info("{} there is already a servlet with the name {}", (Object)SKIPPING_AUTOMATIC_SERVLET_REGISTRATION_BECAUSE, (Object)name);
            return VaadinServletCreation.NO_CREATION;
        }
        ServletDeployer.getLogger().info("Automatically deploying Vaadin servlet with name {} to {}", (Object)name, (Object)path);
        registration.setAsyncSupported(true);
        registration.addMapping(new String[]{path});
        return VaadinServletCreation.SERVLET_CREATED;
    }

    private ServletRegistration findServletByPathPart(ServletContext context, String path) {
        return context.getServletRegistrations().values().stream().filter(registration -> registration.getMappings().contains(path)).findAny().orElse(null);
    }

    private ServletRegistration findVaadinServlet(ServletContext context) {
        return context.getServletRegistrations().values().stream().filter(registration -> this.isVaadinServlet(context.getClassLoader(), registration.getClassName())).findAny().orElse(null);
    }

    private boolean isVaadinServlet(ClassLoader classLoader, String className) {
        return this.loadClass(classLoader, className).map(VaadinServlet.class::isAssignableFrom).orElse(false);
    }

    private Optional<Class<?>> loadClass(ClassLoader classLoader, String className) {
        try {
            return Optional.of(classLoader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            ServletDeployer.getLogger().warn("Failed to load class {}, ignoring it when deploying Vaadin servlets", (Object)className, (Object)e);
            return Optional.empty();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)ServletDeployer.class.getName());
    }

    public static class StubServletConfig
    implements ServletConfig {
        private final ServletContext context;
        private final ServletRegistration registration;

        public StubServletConfig(ServletContext context, ServletRegistration registration) {
            this.context = context;
            this.registration = registration;
        }

        public String getServletName() {
            return this.registration.getName();
        }

        public ServletContext getServletContext() {
            return this.context;
        }

        public String getInitParameter(String name) {
            return this.registration.getInitParameter(name);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(this.registration.getInitParameters().keySet());
        }

        public static DeploymentConfiguration createDeploymentConfiguration(ServletContext context, ServletRegistration registration, Class<?> servletClass) {
            try {
                StubServletConfig servletConfig = new StubServletConfig(context, registration);
                return DeploymentConfigurationFactory.createPropertyDeploymentConfiguration(servletClass, servletConfig);
            }
            catch (ServletException e) {
                throw new IllegalStateException(String.format("Failed to get deployment configuration data for servlet with name '%s' and class '%s'", registration.getName(), servletClass), e);
            }
        }
    }

    private static enum VaadinServletCreation {
        NO_CREATION,
        SERVLET_EXISTS,
        SERVLET_CREATED;

    }
}

