/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.client.ClientResourcesUtils;
import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.BootstrapException;
import com.vaadin.flow.server.BootstrapPageResponse;
import com.vaadin.flow.server.BootstrapUtils;
import com.vaadin.flow.server.InitialPageSettings;
import com.vaadin.flow.server.InlineTargets;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.PwaIcon;
import com.vaadin.flow.server.PwaRegistry;
import com.vaadin.flow.server.ServletHelper;
import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.SystemMessages;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.Version;
import com.vaadin.flow.server.communication.AtmospherePushConnection;
import com.vaadin.flow.server.communication.PushConnectionFactory;
import com.vaadin.flow.server.communication.UidlWriter;
import com.vaadin.flow.shared.VaadinUriResolver;
import com.vaadin.flow.shared.communication.PushMode;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import com.vaadin.flow.theme.ThemeDefinition;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapHandler
extends SynchronizedRequestHandler {
    private static final CharSequence GWT_STAT_EVENTS_JS = "if (typeof window.__gwtStatsEvent != 'function') {window.Vaadin.Flow.gwtStatsEvents = [];window.__gwtStatsEvent = function(event) {window.Vaadin.Flow.gwtStatsEvents.push(event); return true;};};";
    static final String CONTENT_ATTRIBUTE = "content";
    private static final String DEFER_ATTRIBUTE = "defer";
    static final String VIEWPORT = "viewport";
    private static final String META_TAG = "meta";
    private static final String SCRIPT_TAG = "script";
    private static final String CLIENT_ENGINE_NOCACHE_FILE = "VAADIN/static/client/client.nocache.js";
    private static final String BOOTSTRAP_JS = BootstrapHandler.readResource("BootstrapHandler.js");
    private static final String BABEL_HELPERS_JS = BootstrapHandler.readResource("babel-helpers.min.js");
    private static final String ES6_COLLECTIONS = "//<![CDATA[\n" + BootstrapHandler.readResource("es6-collections.js") + "//]]>";
    private static final String CSS_TYPE_ATTRIBUTE_VALUE = "text/css";
    private static final String CAPTION = "caption";
    private static final String MESSAGE = "message";
    private static final String URL = "url";
    static Supplier<String> clientEngineFile = () -> LazyClientEngineInit.access$100();

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)BootstrapHandler.class.getName());
    }

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        Class<? extends UI> uiClass = BootstrapHandler.getUIClass(request);
        BootstrapContext context = this.createAndInitUI(uiClass, request, response, session);
        ServletHelper.setResponseNoCacheHeaders(response::setHeader, response::setDateHeader);
        Document document = BootstrapHandler.getBootstrapPage(context);
        BootstrapHandler.writeBootstrapPage(response, document.outerHtml());
        return true;
    }

    static Document getBootstrapPage(BootstrapContext context) {
        Document document = new Document("");
        DocumentType doctype = new DocumentType("html", "", "", document.baseUri());
        document.appendChild((Node)doctype);
        Element html = document.appendElement("html");
        html.attr("lang", context.getUI().getLocale().getLanguage());
        Element head = html.appendElement("head");
        html.appendElement("body");
        List<Element> dependenciesToInlineInBody = BootstrapHandler.setupDocumentHead(head, context);
        dependenciesToInlineInBody.forEach(dependency -> document.body().appendChild((Node)dependency));
        BootstrapHandler.setupDocumentBody(document);
        document.outputSettings().prettyPrint(false);
        BootstrapUtils.getInlineTargets(context).ifPresent(targets -> BootstrapHandler.handleInlineTargets(context, head, document.body(), targets));
        BootstrapUtils.getInitialPageSettings(context).ifPresent(initialPageSettings -> BootstrapHandler.handleInitialPageSettings(context, head, initialPageSettings));
        BootstrapHandler.handleThemeContents(context, document);
        if (!context.isProductionMode()) {
            BootstrapHandler.exportUsageStatistics(document);
        }
        BootstrapHandler.setupPwa(document, context);
        BootstrapPageResponse response = new BootstrapPageResponse(context.getRequest(), context.getSession(), context.getResponse(), document, context.getUI(), context.getUriResolver());
        context.getSession().getService().modifyBootstrapPage(response);
        return document;
    }

    private static void exportUsageStatistics(Document document) {
        String registerScript = UsageStatistics.getEntries().map(entry -> {
            String name = entry.getName();
            String version = entry.getVersion();
            JsonObject json = Json.createObject();
            json.put("is", name);
            json.put("version", version);
            String escapedName = Json.create((String)name).toJson();
            return String.format("window.Vaadin[%s]=%s;", escapedName, json);
        }).collect(Collectors.joining("\n"));
        if (!registerScript.isEmpty()) {
            document.body().appendElement(SCRIPT_TAG).text(registerScript);
        }
    }

    private static void handleThemeContents(BootstrapContext context, Document document) {
        JsonObject themeContent;
        BootstrapUtils.ThemeSettings themeSettings = BootstrapUtils.getThemeSettings(context);
        if (themeSettings == null) {
            return;
        }
        List<JsonObject> themeContents = themeSettings.getHeadContents();
        if (themeContents != null) {
            themeContents.stream().map(dependency -> BootstrapHandler.createDependencyElement(context, dependency)).forEach(element -> BootstrapHandler.insertElements(element, arg_0 -> ((Element)document.head()).appendChild(arg_0)));
        }
        if ((themeContent = themeSettings.getHeadInjectedContent()) != null) {
            Element dependency2 = BootstrapHandler.createDependencyElement(context, themeContent);
            BootstrapHandler.insertElements(dependency2, arg_0 -> ((Element)document.head()).appendChild(arg_0));
        }
        if (themeSettings.getBodyAttributes() != null) {
            themeSettings.getBodyAttributes().forEach((key, value) -> document.body().attr(key, value));
        }
    }

    private static void handleInlineTargets(BootstrapContext context, Element head, Element body, InlineTargets targets) {
        targets.getInlineHead(Inline.Position.PREPEND).stream().map(dependency -> BootstrapHandler.createDependencyElement(context, dependency)).forEach(element -> BootstrapHandler.insertElements(element, arg_0 -> ((Element)head).prependChild(arg_0)));
        targets.getInlineHead(Inline.Position.APPEND).stream().map(dependency -> BootstrapHandler.createDependencyElement(context, dependency)).forEach(element -> BootstrapHandler.insertElements(element, arg_0 -> ((Element)head).appendChild(arg_0)));
        targets.getInlineBody(Inline.Position.PREPEND).stream().map(dependency -> BootstrapHandler.createDependencyElement(context, dependency)).forEach(element -> BootstrapHandler.insertElements(element, arg_0 -> ((Element)body).prependChild(arg_0)));
        targets.getInlineBody(Inline.Position.APPEND).stream().map(dependency -> BootstrapHandler.createDependencyElement(context, dependency)).forEach(element -> BootstrapHandler.insertElements(element, arg_0 -> ((Element)body).appendChild(arg_0)));
    }

    private static void handleInitialPageSettings(BootstrapContext context, Element head, InitialPageSettings initialPageSettings) {
        if (initialPageSettings.getViewport() != null) {
            Elements viewport = head.getElementsByAttributeValue("name", VIEWPORT);
            if (!viewport.isEmpty() && viewport.size() == 1) {
                ((Element)viewport.get(0)).attr(CONTENT_ATTRIBUTE, initialPageSettings.getViewport());
            } else {
                head.appendElement(META_TAG).attr("name", VIEWPORT).attr(CONTENT_ATTRIBUTE, initialPageSettings.getViewport());
            }
        }
        initialPageSettings.getInline(InitialPageSettings.Position.PREPEND).stream().map(dependency -> BootstrapHandler.createDependencyElement(context, dependency)).forEach(element -> BootstrapHandler.insertElements(element, arg_0 -> ((Element)head).prependChild(arg_0)));
        initialPageSettings.getInline(InitialPageSettings.Position.APPEND).stream().map(dependency -> BootstrapHandler.createDependencyElement(context, dependency)).forEach(element -> BootstrapHandler.insertElements(element, arg_0 -> ((Element)head).appendChild(arg_0)));
        initialPageSettings.getElement(InitialPageSettings.Position.PREPEND).forEach(element -> BootstrapHandler.insertElements(element, arg_0 -> ((Element)head).prependChild(arg_0)));
        initialPageSettings.getElement(InitialPageSettings.Position.APPEND).forEach(element -> BootstrapHandler.insertElements(element, arg_0 -> ((Element)head).appendChild(arg_0)));
    }

    private static void insertElements(Element element, Consumer<Element> action) {
        if (element instanceof Document) {
            element.getAllElements().stream().filter(item -> !(item instanceof Document) && element.equals((Object)item.parent())).forEach(action::accept);
        } else {
            action.accept(element);
        }
    }

    private static void writeBootstrapPage(VaadinResponse response, String html) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(response.getOutputStream(), StandardCharsets.UTF_8));){
            writer.append(html);
        }
    }

    private static List<Element> setupDocumentHead(Element head, BootstrapContext context) {
        BootstrapHandler.setupMetaAndTitle(head, context);
        BootstrapHandler.setupCss(head, context);
        JsonObject initialUIDL = BootstrapHandler.getInitialUidl(context.getUI());
        Map<LoadMode, JsonArray> dependenciesToProcessOnServer = BootstrapHandler.popDependenciesToProcessOnServer(initialUIDL);
        BootstrapHandler.setupFrameworkLibraries(head, initialUIDL, context);
        return BootstrapHandler.applyUserDependencies(head, context, dependenciesToProcessOnServer);
    }

    private static List<Element> applyUserDependencies(Element head, BootstrapContext context, Map<LoadMode, JsonArray> dependenciesToProcessOnServer) {
        ArrayList<Element> dependenciesToInlineInBody = new ArrayList<Element>();
        for (Map.Entry<LoadMode, JsonArray> entry : dependenciesToProcessOnServer.entrySet()) {
            dependenciesToInlineInBody.addAll(BootstrapHandler.inlineDependenciesInHead(head, context.getUriResolver(), entry.getKey(), entry.getValue()));
        }
        return dependenciesToInlineInBody;
    }

    private static List<Element> inlineDependenciesInHead(Element head, BootstrapUriResolver uriResolver, LoadMode loadMode, JsonArray dependencies) {
        ArrayList<Element> dependenciesToInlineInBody = new ArrayList<Element>();
        for (int i = 0; i < dependencies.length(); ++i) {
            JsonObject dependencyJson = dependencies.getObject(i);
            Dependency.Type dependencyType = Dependency.Type.valueOf(dependencyJson.getString("type"));
            Element dependencyElement = BootstrapHandler.createDependencyElement(uriResolver, loadMode, dependencyJson, dependencyType);
            if (loadMode == LoadMode.INLINE && dependencyType == Dependency.Type.HTML_IMPORT) {
                dependenciesToInlineInBody.add(dependencyElement);
                continue;
            }
            head.appendChild((Node)dependencyElement);
        }
        return dependenciesToInlineInBody;
    }

    private static Map<LoadMode, JsonArray> popDependenciesToProcessOnServer(JsonObject initialUIDL) {
        EnumMap<LoadMode, JsonArray> result = new EnumMap<LoadMode, JsonArray>(LoadMode.class);
        Stream.of(LoadMode.EAGER, LoadMode.INLINE).forEach(mode -> {
            if (initialUIDL.hasKey(mode.name())) {
                result.put((LoadMode)((Object)mode), initialUIDL.getArray(mode.name()));
                initialUIDL.remove(mode.name());
            }
        });
        return result;
    }

    private static void setupFrameworkLibraries(Element head, JsonObject initialUIDL, BootstrapContext context) {
        BootstrapHandler.inlineEs6Collections(head, context);
        BootstrapHandler.appendWebComponentsPolyfills(head, context);
        if (context.getPushMode().isEnabled()) {
            head.appendChild((Node)BootstrapHandler.getPushScript(context));
        }
        head.appendChild((Node)BootstrapHandler.getBootstrapScript((JsonValue)initialUIDL, context));
        head.appendChild((Node)BootstrapHandler.createJavaScriptElement(BootstrapHandler.getClientEngineUrl(context)));
    }

    private static void inlineEs6Collections(Element head, BootstrapContext context) {
        if (!context.getSession().getBrowser().isEs6Supported()) {
            head.appendChild((Node)BootstrapHandler.createInlineJavaScriptElement(ES6_COLLECTIONS));
        }
    }

    private static void setupCss(Element head, BootstrapContext context) {
        Element styles = head.appendElement("style").attr("type", CSS_TYPE_ATTRIBUTE_VALUE);
        String bodySizeContent = BootstrapUtils.getBodySizeContent(context);
        styles.appendText(bodySizeContent);
        styles.appendText(".v-reconnect-dialog {position: absolute;top: 1em;right: 1em;border: 1px solid black;padding: 1em;z-index: 10000;}");
        styles.appendText(".v-system-error {color: red;background: white;position: absolute;top: 1em;right: 1em;border: 1px solid black;padding: 1em;z-index: 10000;pointer-events: auto;}");
    }

    private static void setupMetaAndTitle(Element head, BootstrapContext context) {
        head.appendElement(META_TAG).attr("http-equiv", "Content-Type").attr(CONTENT_ATTRIBUTE, "text/html; charset=utf-8");
        head.appendElement(META_TAG).attr("http-equiv", "X-UA-Compatible").attr(CONTENT_ATTRIBUTE, "IE=edge");
        head.appendElement("base").attr("href", BootstrapHandler.getServiceUrl(context));
        head.appendElement(META_TAG).attr("name", VIEWPORT).attr(CONTENT_ATTRIBUTE, BootstrapUtils.getViewportContent(context).orElse("width=device-width, initial-scale=1.0"));
        if (!BootstrapUtils.getMetaTargets(context).isEmpty()) {
            BootstrapUtils.getMetaTargets(context).forEach((name, content) -> head.appendElement(META_TAG).attr("name", name).attr(CONTENT_ATTRIBUTE, content));
        }
        BootstrapHandler.resolvePageTitle(context).ifPresent(title -> {
            if (!title.isEmpty()) {
                head.appendElement("title").appendText(title);
            }
        });
    }

    private static void setupPwa(Document document, BootstrapContext context) {
        VaadinService vaadinService = context.getSession().getService();
        if (vaadinService == null) {
            return;
        }
        PwaRegistry registry = vaadinService.getPwaRegistry();
        if (registry == null) {
            return;
        }
        PwaConfiguration config = registry.getPwaConfiguration();
        if (config.isEnabled()) {
            Element head = document.head();
            head.appendElement(META_TAG).attr("name", "apple-mobile-web-app-capable").attr(CONTENT_ATTRIBUTE, "yes");
            head.appendElement(META_TAG).attr("name", "theme-color").attr(CONTENT_ATTRIBUTE, config.getThemeColor());
            head.appendElement(META_TAG).attr("name", "apple-mobile-web-app-status-bar-style").attr(CONTENT_ATTRIBUTE, config.getThemeColor());
            head.appendElement("link").attr("rel", "manifest").attr("href", config.getManifestPath());
            for (PwaIcon icon : registry.getHeaderIcons()) {
                head.appendChild((Node)icon.asElement());
            }
            head.appendElement(SCRIPT_TAG).text("if ('serviceWorker' in navigator) {\n  window.addEventListener('load', function() {\n    navigator.serviceWorker.register('" + config.getServiceWorkerPath() + "');\n  });\n}");
            if (registry.getPwaConfiguration().isInstallPromptEnabled()) {
                document.body().append(registry.getInstallPrompt());
            }
        }
    }

    private static void appendWebComponentsPolyfills(Element head, BootstrapContext context) {
        VaadinSession session = context.getSession();
        DeploymentConfiguration config = session.getConfiguration();
        String webcomponentsLoaderUrl = "frontend://bower_components/webcomponentsjs/webcomponents-loader.js";
        String es5AdapterUrl = "frontend://bower_components/webcomponentsjs/custom-elements-es5-adapter.js";
        VaadinService service = session.getService();
        if (!service.isResourceAvailable(webcomponentsLoaderUrl, session.getBrowser(), null)) {
            return;
        }
        boolean loadEs5Adapter = config.getBooleanProperty("load.es5.adapters", true);
        if (loadEs5Adapter && !session.getBrowser().isEs6Supported()) {
            head.appendChild((Node)BootstrapHandler.createInlineJavaScriptElement(BABEL_HELPERS_JS));
            if (session.getBrowser().isEs5AdapterNeeded()) {
                head.appendChild((Node)BootstrapHandler.createJavaScriptElement(context.getUriResolver().resolveVaadinUri(es5AdapterUrl), false));
            }
        }
        String resolvedUrl = context.getUriResolver().resolveVaadinUri(webcomponentsLoaderUrl);
        head.appendChild((Node)BootstrapHandler.createJavaScriptElement(resolvedUrl, false));
    }

    private static Element createInlineJavaScriptElement(String javaScriptContents) {
        Element wrapper = BootstrapHandler.createJavaScriptElement(null, false);
        wrapper.appendChild((Node)new DataNode(javaScriptContents, wrapper.baseUri()));
        return wrapper;
    }

    private static Element createJavaScriptElement(String sourceUrl, boolean defer) {
        Element jsElement = new Element(Tag.valueOf((String)SCRIPT_TAG), "").attr("type", "text/javascript").attr(DEFER_ATTRIBUTE, defer);
        if (sourceUrl != null) {
            jsElement = jsElement.attr("src", sourceUrl);
        }
        return jsElement;
    }

    private static Element createJavaScriptElement(String sourceUrl) {
        return BootstrapHandler.createJavaScriptElement(sourceUrl, true);
    }

    private static Element createDependencyElement(BootstrapUriResolver resolver, LoadMode loadMode, JsonObject dependency, Dependency.Type type) {
        Element dependencyElement;
        boolean inlineElement = loadMode == LoadMode.INLINE;
        String url = dependency.hasKey(URL) ? resolver.resolveVaadinUri(dependency.getString(URL)) : null;
        switch (type) {
            case STYLESHEET: {
                dependencyElement = BootstrapHandler.createStylesheetElement(url);
                break;
            }
            case JAVASCRIPT: {
                dependencyElement = BootstrapHandler.createJavaScriptElement(url, !inlineElement);
                break;
            }
            case HTML_IMPORT: {
                dependencyElement = BootstrapHandler.createHtmlImportElement(url);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported dependency type: " + (Object)((Object)type));
            }
        }
        if (inlineElement) {
            dependencyElement.appendChild((Node)new DataNode(dependency.getString("contents"), dependencyElement.baseUri()));
        }
        return dependencyElement;
    }

    private static Element createHtmlImportElement(String url) {
        Element htmlImportElement = url != null ? new Element(Tag.valueOf((String)"link"), "").attr("rel", "import").attr("href", url) : new Element(Tag.valueOf((String)"span"), "").attr("hidden", true);
        return htmlImportElement;
    }

    private static Element createStylesheetElement(String url) {
        Element cssElement = url != null ? new Element(Tag.valueOf((String)"link"), "").attr("rel", "stylesheet").attr("type", CSS_TYPE_ATTRIBUTE_VALUE).attr("href", url) : new Element(Tag.valueOf((String)"style"), "").attr("type", CSS_TYPE_ATTRIBUTE_VALUE);
        return cssElement;
    }

    private static void setupDocumentBody(Document document) {
        document.body().appendElement("noscript").append("You have to enable javascript in your browser to use this web site.");
    }

    private static Element getPushScript(BootstrapContext context) {
        VaadinRequest request = context.getRequest();
        String versionQueryParam = "?v=" + Version.getFullVersion();
        String pushJSPath = ServletHelper.getContextRootRelativePath(request) + "/";
        pushJSPath = request.getService().getDeploymentConfiguration().isProductionMode() ? pushJSPath + "VAADIN/static/push/vaadinPush-min.js" : pushJSPath + "VAADIN/static/push/vaadinPush.js";
        pushJSPath = pushJSPath + versionQueryParam;
        return BootstrapHandler.createJavaScriptElement(pushJSPath);
    }

    private static Element getBootstrapScript(JsonValue initialUIDL, BootstrapContext context) {
        return BootstrapHandler.createInlineJavaScriptElement("//<![CDATA[\n" + BootstrapHandler.getBootstrapJS(initialUIDL, context) + "//]]>");
    }

    private static String getBootstrapJS(JsonValue initialUIDL, BootstrapContext context) {
        boolean productionMode = context.getSession().getConfiguration().isProductionMode();
        String result = BootstrapHandler.getBootstrapJS();
        JsonObject appConfig = context.getApplicationParameters();
        int indent = 0;
        if (!productionMode) {
            indent = 4;
        }
        String appConfigString = JsonUtil.stringify((JsonValue)appConfig, (int)indent);
        String initialUIDLString = JsonUtil.stringify((JsonValue)initialUIDL, (int)indent);
        initialUIDLString = initialUIDLString.replace("<", "\\x3C");
        result = !productionMode ? result.replace("{{GWT_STAT_EVENTS}}", GWT_STAT_EVENTS_JS) : result.replace("{{GWT_STAT_EVENTS}}", "");
        result = result.replace("{{APP_ID}}", context.getAppId());
        result = result.replace("{{CONFIG_JSON}}", appConfigString);
        result = result.replace("{{INITIAL_UIDL}}", initialUIDLString);
        return result;
    }

    protected static JsonObject getApplicationParameters(BootstrapContext context) {
        JsonObject appConfig = BootstrapHandler.getApplicationParameters(context.getRequest(), context.getSession());
        appConfig.put("v-uiId", (double)context.getUI().getUIId());
        return appConfig;
    }

    private static JsonObject getApplicationParameters(VaadinRequest request, VaadinSession session) {
        Locale locale;
        SystemMessages systemMessages;
        VaadinService vaadinService = session.getService();
        DeploymentConfiguration deploymentConfiguration = session.getConfiguration();
        boolean productionMode = deploymentConfiguration.isProductionMode();
        JsonObject appConfig = Json.createObject();
        appConfig.put("frontendUrlEs6", deploymentConfiguration.getEs6FrontendPrefix());
        appConfig.put("frontendUrlEs5", deploymentConfiguration.getEs5FrontendPrefix());
        if (!productionMode) {
            JsonObject versionInfo = Json.createObject();
            versionInfo.put("vaadinVersion", Version.getFullVersion());
            String atmosphereVersion = AtmospherePushConnection.getAtmosphereVersion();
            if (atmosphereVersion != null) {
                versionInfo.put("atmosphereVersion", atmosphereVersion);
            }
            appConfig.put("versionInfo", (JsonValue)versionInfo);
        }
        if ((systemMessages = vaadinService.getSystemMessages(locale = ServletHelper.findLocale(session, request), request)) != null) {
            JsonObject sessExpMsg = Json.createObject();
            BootstrapHandler.putValueOrNull(sessExpMsg, CAPTION, systemMessages.getSessionExpiredCaption());
            BootstrapHandler.putValueOrNull(sessExpMsg, MESSAGE, systemMessages.getSessionExpiredMessage());
            BootstrapHandler.putValueOrNull(sessExpMsg, URL, systemMessages.getSessionExpiredURL());
            appConfig.put("sessExpMsg", (JsonValue)sessExpMsg);
        }
        String contextRoot = ServletHelper.getContextRootRelativePath(request) + "/";
        appConfig.put("contextRootUrl", contextRoot);
        if (!productionMode) {
            appConfig.put("debug", true);
        }
        if (deploymentConfiguration.isRequestTiming()) {
            appConfig.put("requestTiming", true);
        }
        appConfig.put("heartbeatInterval", (double)deploymentConfiguration.getHeartbeatInterval());
        boolean sendUrlsAsParameters = deploymentConfiguration.isSendUrlsAsParameters();
        if (!sendUrlsAsParameters) {
            appConfig.put("sendUrlsAsParameters", false);
        }
        return appConfig;
    }

    protected static String getServiceUrl(BootstrapContext context) {
        String pathInfo = context.getRequest().getPathInfo();
        if (pathInfo == null) {
            return ".";
        }
        return ServletHelper.getCancelingRelativePath(pathInfo);
    }

    protected static Optional<String> resolvePageTitle(BootstrapContext context) {
        String title = context.getUI().getInternals().getTitle();
        if (title != null) {
            context.getUI().getInternals().cancelPendingTitleUpdate();
        }
        return Optional.ofNullable(title);
    }

    protected BootstrapContext createAndInitUI(Class<? extends UI> uiClass, VaadinRequest request, VaadinResponse response, VaadinSession session) {
        UI ui = ReflectTools.createInstance(uiClass);
        ui.getInternals().setContextRoot(ServletHelper.getContextRootRelativePath(request) + "/");
        PushConfiguration pushConfiguration = ui.getPushConfiguration();
        ui.getInternals().setSession(session);
        ui.setLocale(session.getLocale());
        BootstrapContext context = new BootstrapContext(request, response, session, ui);
        Optional<Push> push = context.getPageConfigurationAnnotation(Push.class);
        DeploymentConfiguration deploymentConfiguration = context.getSession().getService().getDeploymentConfiguration();
        PushMode pushMode = push.map(Push::value).orElseGet(deploymentConfiguration::getPushMode);
        this.setupPushConnectionFactory(pushConfiguration, context);
        pushConfiguration.setPushMode(pushMode);
        pushConfiguration.setPushUrl(deploymentConfiguration.getPushURL());
        push.map(Push::transport).ifPresent(pushConfiguration::setTransport);
        UI.setCurrent(ui);
        ui.doInit(request, session.getNextUIid());
        session.addUI(ui);
        session.getService().fireUIInitListeners(ui);
        if (ui.getRouter() != null) {
            ui.getRouter().initializeUI(ui, request);
        }
        return context;
    }

    protected void setupPushConnectionFactory(PushConfiguration pushConfiguration, BootstrapContext context) {
        VaadinService service = context.getSession().getService();
        Iterator<PushConnectionFactory> iter = ServiceLoader.load(PushConnectionFactory.class, service.getClassLoader()).iterator();
        if (iter.hasNext()) {
            pushConfiguration.setPushConnectionFactory(iter.next());
            if (iter.hasNext()) {
                throw new BootstrapException("Multiple " + PushConnectionFactory.class.getName() + " implementations found");
            }
        }
    }

    protected static JsonObject getInitialUidl(UI ui) {
        JsonObject json = new UidlWriter().createUidl(ui, false);
        VaadinSession session = ui.getSession();
        if (session.getConfiguration().isXsrfProtectionEnabled()) {
            BootstrapHandler.writeSecurityKeyUIDL(json, session);
        }
        BootstrapHandler.writePushIdUIDL(json, session);
        if (BootstrapHandler.getLogger().isDebugEnabled()) {
            BootstrapHandler.getLogger().debug("Initial UIDL: {}", (Object)json.asString());
        }
        return json;
    }

    private static void writeSecurityKeyUIDL(JsonObject response, VaadinSession session) {
        String seckey = session.getCsrfToken();
        response.put("Vaadin-Security-Key", seckey);
    }

    private static void writePushIdUIDL(JsonObject response, VaadinSession session) {
        String pushId = session.getPushId();
        response.put("Vaadin-Push-ID", pushId);
    }

    private static void putValueOrNull(JsonObject object, String key, String value) {
        assert (object != null);
        assert (key != null);
        if (value == null) {
            object.put(key, (JsonValue)Json.createNull());
        } else {
            object.put(key, value);
        }
    }

    private static String getBootstrapJS() {
        if (BOOTSTRAP_JS.isEmpty()) {
            throw new BootstrapException("BootstrapHandler.js has not been loaded during initialization");
        }
        return BOOTSTRAP_JS;
    }

    private static String getClientEngineUrl(BootstrapContext context) {
        boolean resolveNow;
        boolean productionMode = context.getSession().getConfiguration().isProductionMode();
        boolean bl = resolveNow = !productionMode || BootstrapHandler.getClientEngine() == null;
        if (resolveNow && ClientResourcesUtils.getResource("/META-INF/resources/VAADIN/static/client/client.nocache.js") != null) {
            return context.getUriResolver().resolveVaadinUri("context://VAADIN/static/client/client.nocache.js");
        }
        if (BootstrapHandler.getClientEngine() == null) {
            throw new BootstrapException("Client engine file name has not been resolved during initialization");
        }
        return context.getUriResolver().resolveVaadinUri("context://" + BootstrapHandler.getClientEngine());
    }

    protected static Class<? extends UI> getUIClass(VaadinRequest request) {
        String uiClassName = request.getService().getDeploymentConfiguration().getUIClassName();
        if (uiClassName == null) {
            throw new BootstrapException("Could not determine the uiClassName for the request path " + request.getPathInfo());
        }
        ClassLoader classLoader = request.getService().getClassLoader();
        try {
            return Class.forName(uiClassName, true, classLoader).asSubclass(UI.class);
        }
        catch (ClassNotFoundException e) {
            throw new BootstrapException("Vaadin Servlet mapped to the request path " + request.getPathInfo() + " cannot find the mapped UI class with name " + uiClassName, e);
        }
    }

    /*
     * Exception decompiling
     */
    protected static String readResource(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Element createDependencyElement(BootstrapContext context, JsonObject dependencyJson) {
        String type = dependencyJson.getString("type");
        if (Dependency.Type.contains(type)) {
            Dependency.Type dependencyType = Dependency.Type.valueOf(type);
            return BootstrapHandler.createDependencyElement(context.getUriResolver(), LoadMode.INLINE, dependencyJson, dependencyType);
        }
        return Jsoup.parse((String)dependencyJson.getString("contents"), (String)"", (Parser)Parser.xmlParser());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readClientEngine() {
        try (InputStream prop = ClientResourcesUtils.getResource("/META-INF/resources/VAADIN/static/client/compile.properties");){
            if (prop != null) {
                Properties properties = new Properties();
                properties.load(prop);
                String string = "VAADIN/static/client/" + properties.getProperty("jsFile");
                return string;
            }
            BootstrapHandler.getLogger().warn("No compile.properties available on initialization, could not read client engine file name.");
            return null;
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static String getClientEngine() {
        return clientEngineFile.get();
    }

    static /* synthetic */ String access$000() {
        return BootstrapHandler.readClientEngine();
    }

    private static class LazyClientEngineInit {
        private static final String CLIENT_ENGINE_FILE = BootstrapHandler.access$000();

        private LazyClientEngineInit() {
        }
    }

    public static class BootstrapUriResolver
    extends VaadinUriResolver {
        private String frontendRootUrl;
        private String servletPathToContextRoot;

        protected BootstrapUriResolver(UI ui) {
            this.servletPathToContextRoot = ui.getInternals().getContextRootRelativePath();
            VaadinSession session = ui.getSession();
            DeploymentConfiguration config = session.getConfiguration();
            this.frontendRootUrl = session.getBrowser().isEs6Supported() ? config.getEs6FrontendPrefix() : config.getEs5FrontendPrefix();
            assert (this.frontendRootUrl.endsWith("/"));
            assert (this.servletPathToContextRoot.endsWith("/"));
        }

        public String resolveVaadinUri(String uri) {
            return super.resolveVaadinUri(uri, this.frontendRootUrl, this.servletPathToContextRoot);
        }
    }

    protected static class BootstrapContext {
        private final VaadinRequest request;
        private final VaadinResponse response;
        private final VaadinSession session;
        private final UI ui;
        private final Class<?> pageConfigurationHolder;
        private String appId;
        private PushMode pushMode;
        private JsonObject applicationParameters;
        private BootstrapUriResolver uriResolver;

        protected BootstrapContext(VaadinRequest request, VaadinResponse response, VaadinSession session, UI ui) {
            this.request = request;
            this.response = response;
            this.session = session;
            this.ui = ui;
            this.pageConfigurationHolder = BootstrapUtils.resolvePageConfigurationHolder(ui, request).orElse(null);
        }

        public VaadinResponse getResponse() {
            return this.response;
        }

        public VaadinRequest getRequest() {
            return this.request;
        }

        public VaadinSession getSession() {
            return this.session;
        }

        public UI getUI() {
            return this.ui;
        }

        public PushMode getPushMode() {
            if (this.pushMode == null) {
                this.pushMode = this.getUI().getPushConfiguration().getPushMode();
                if (this.pushMode == null) {
                    this.pushMode = this.getRequest().getService().getDeploymentConfiguration().getPushMode();
                }
                if (this.pushMode.isEnabled() && !this.getRequest().getService().ensurePushAvailable()) {
                    this.pushMode = PushMode.DISABLED;
                }
            }
            return this.pushMode;
        }

        public String getAppId() {
            if (this.appId == null) {
                this.appId = this.getRequest().getService().getMainDivId(this.getSession(), this.getRequest());
            }
            return this.appId;
        }

        public JsonObject getApplicationParameters() {
            if (this.applicationParameters == null) {
                this.applicationParameters = BootstrapHandler.getApplicationParameters(this);
            }
            return this.applicationParameters;
        }

        public BootstrapUriResolver getUriResolver() {
            if (this.uriResolver == null) {
                this.uriResolver = new BootstrapUriResolver(this.getUI());
            }
            return this.uriResolver;
        }

        public boolean isProductionMode() {
            return this.request.getService().getDeploymentConfiguration().isProductionMode();
        }

        public <T extends Annotation> Optional<T> getPageConfigurationAnnotation(Class<T> annotationType) {
            if (this.pageConfigurationHolder == null) {
                return Optional.empty();
            }
            return AnnotationReader.getAnnotationFor(this.pageConfigurationHolder, annotationType);
        }

        public <T extends Annotation> List<T> getPageConfigurationAnnotations(Class<T> annotationType) {
            if (this.pageConfigurationHolder == null) {
                return Collections.emptyList();
            }
            return AnnotationReader.getAnnotationsFor(this.pageConfigurationHolder, annotationType);
        }

        protected Optional<ThemeDefinition> getTheme() {
            return this.ui.getThemeFor(this.pageConfigurationHolder, null);
        }
    }
}

