/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.theme.NoTheme;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.safety.Whitelist;
import org.slf4j.LoggerFactory;

@Tag(value="div")
@NoTheme
public class RouteNotFoundError
extends Component
implements HasErrorParameter<NotFoundException> {
    @Override
    public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<NotFoundException> parameter) {
        String path = event.getLocation().getPath();
        String additionalInfo = "";
        if (parameter.hasCustomMessage()) {
            additionalInfo = "Reason: " + parameter.getCustomMessage();
        }
        path = Jsoup.clean((String)path, (Whitelist)Whitelist.none());
        additionalInfo = Jsoup.clean((String)additionalInfo, (Whitelist)Whitelist.none());
        boolean productionMode = event.getUI().getSession().getConfiguration().isProductionMode();
        String template = RouteNotFoundError.getErrorHtml(productionMode);
        template = template.replace("{{path}}", path);
        if ((template = template.replace("{{additionalInfo}}", additionalInfo)).contains("{{routes}}")) {
            template = template.replace("{{routes}}", this.getRoutes(event));
        }
        this.getElement().appendChild(new Html(template).getElement());
        return 404;
    }

    private static String getErrorHtml(boolean productionMode) {
        if (productionMode) {
            return LazyInit.PRODUCTION_MODE_TEMPLATE;
        }
        return RouteNotFoundError.readHtmlFile("RouteNotFoundError_dev.html");
    }

    private static String readHtmlFile(String templateName) {
        try {
            return IOUtils.toString((InputStream)RouteNotFoundError.class.getResourceAsStream(templateName), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(RouteNotFoundError.class).error("Unable to read " + templateName, (Throwable)e);
            return "Could not navigate to '{{path}}'";
        }
    }

    private String getRoutes(BeforeEnterEvent event) {
        List<RouteData> routes = event.getSource().getRegistry().getRegisteredRoutes();
        return routes.stream().sorted((route1, route2) -> route1.getUrl().compareTo(route2.getUrl())).map(this::routeToHtml).map(Node::outerHtml).collect(Collectors.joining());
    }

    private Element routeToHtml(RouteData route) {
        String text = route.getUrl();
        if (text == null || text.isEmpty()) {
            text = "<root>";
        }
        if (route.getParameters().isEmpty()) {
            Element link = new Element("a").attr("href", route.getUrl()).text(text);
            return new Element("li").appendChild((Node)link);
        }
        return new Element("li").text(text + " (requires parameter)");
    }

    static /* synthetic */ String access$100(String x0) {
        return RouteNotFoundError.readHtmlFile(x0);
    }

    private static class LazyInit {
        private static final String PRODUCTION_MODE_TEMPLATE = RouteNotFoundError.access$100("RouteNotFoundError_prod.html");

        private LazyInit() {
        }
    }
}

