/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.ComponentMetaData;
import com.vaadin.flow.component.internal.DependencyList;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.impl.BasicElementStateProvider;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.ConstantPool;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.LoadingIndicatorConfigurationMap;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.PollConfigurationMap;
import com.vaadin.flow.internal.nodefeature.PushConfigurationMap;
import com.vaadin.flow.internal.nodefeature.ReconnectDialogConfigurationMap;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.BeforeLeaveListener;
import com.vaadin.flow.router.ListenerPriority;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.AfterNavigationHandler;
import com.vaadin.flow.router.internal.BeforeEnterHandler;
import com.vaadin.flow.router.internal.BeforeLeaveHandler;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WebBrowser;
import com.vaadin.flow.server.communication.PushConnection;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.communication.PushMode;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIInternals
implements Serializable {
    private int lastProcessedClientToServerId = -1;
    private int serverSyncId = 0;
    private final StateTree stateTree;
    private PushConnection pushConnection = null;
    private long lastHeartbeatTimestamp = System.currentTimeMillis();
    private List<JavaScriptInvocation> pendingJsInvocations = new ArrayList<JavaScriptInvocation>();
    private final UI ui;
    private String title;
    private Page.ExecutionCanceler pendingTitleUpdateCanceler;
    private Location viewLocation = new Location("");
    private ArrayList<HasElement> routerTargetChain = new ArrayList();
    private HashMap<Class<?>, List<?>> listeners = new HashMap();
    private Location lastHandledNavigation = null;
    private BeforeLeaveEvent.ContinueNavigationAction continueNavigationAction = null;
    private volatile VaadinSession session;
    private final DependencyList dependencyList = new DependencyList();
    private final ConstantPool constantPool = new ConstantPool();
    private AbstractTheme theme = null;
    private static final Pattern componentSource = Pattern.compile(".*/src/vaadin-([\\w\\-]*).html");
    private byte[] lastProcessedMessageHash = null;
    private String contextRootRelativePath;
    private String appId;

    public UIInternals(UI ui) {
        this.ui = ui;
        this.stateTree = new StateTree(this, UIInternals.getRootNodeFeatures());
    }

    public StateTree getStateTree() {
        return this.stateTree;
    }

    public int getLastProcessedClientToServerId() {
        return this.lastProcessedClientToServerId;
    }

    public byte[] getLastProcessedMessageHash() {
        return this.lastProcessedMessageHash;
    }

    public void setLastProcessedClientToServerId(int lastProcessedClientToServerId, byte[] lastProcessedMessageHash) {
        this.lastProcessedClientToServerId = lastProcessedClientToServerId;
        this.lastProcessedMessageHash = lastProcessedMessageHash;
    }

    public int getServerSyncId() {
        return this.serverSyncId;
    }

    public void incrementServerId() {
        ++this.serverSyncId;
    }

    public long getLastHeartbeatTimestamp() {
        return this.lastHeartbeatTimestamp;
    }

    public void setLastHeartbeatTimestamp(long lastHeartbeat) {
        this.lastHeartbeatTimestamp = lastHeartbeat;
    }

    private static Class<? extends NodeFeature>[] getRootNodeFeatures() {
        ArrayList<Class<? extends NodeFeature>> features = new ArrayList<Class<? extends NodeFeature>>(BasicElementStateProvider.getFeatures());
        features.add(PushConfigurationMap.class);
        features.add(PollConfigurationMap.class);
        features.add(ReconnectDialogConfigurationMap.class);
        features.add(LoadingIndicatorConfigurationMap.class);
        assert (features.size() == new HashSet<Class<? extends NodeFeature>>(features).size()) : "There are duplicates";
        return features.toArray(new Class[0]);
    }

    private static String getSessionDetails(VaadinSession session) {
        if (session == null) {
            return null;
        }
        return session + " for " + session.getService().getServiceName();
    }

    public void setSession(VaadinSession session) {
        if (session == null && this.session == null) {
            throw new IllegalStateException("Session should never be set to null when UI.session is already null");
        }
        if (session != null && this.session != null) {
            throw new IllegalStateException("Session has already been set. Old session: " + UIInternals.getSessionDetails(this.session) + ". New session: " + UIInternals.getSessionDetails(session) + ".");
        }
        if (session == null) {
            this.ui.getElement().getNode().setParent(null);
            this.ui.getPushConfiguration().setPushMode(PushMode.DISABLED);
            this.setPushConnection(null);
        }
        this.session = session;
        if (session != null) {
            ComponentUtil.onComponentAttach(this.ui, true);
        }
    }

    public PushConnection getPushConnection() {
        assert (!this.ui.getPushConfiguration().getPushMode().isEnabled() || this.pushConnection != null);
        return this.pushConnection;
    }

    public void setPushConnection(PushConnection pushConnection) {
        assert (pushConnection == null ^ this.ui.getPushConfiguration().getPushMode().isEnabled());
        if (pushConnection == this.pushConnection) {
            return;
        }
        if (this.pushConnection != null && this.pushConnection.isConnected()) {
            this.pushConnection.disconnect();
        }
        this.pushConnection = pushConnection;
    }

    public Registration addBeforeEnterListener(BeforeEnterListener listener) {
        return this.addNavigationListener(BeforeEnterHandler.class, listener);
    }

    public Registration addBeforeLeaveListener(BeforeLeaveListener listener) {
        return this.addNavigationListener(BeforeLeaveHandler.class, listener);
    }

    public Registration addAfterNavigationListener(AfterNavigationListener listener) {
        return this.addNavigationListener(AfterNavigationHandler.class, listener);
    }

    private <E> Registration addNavigationListener(Class<E> navigationHandler, E listener) {
        this.session.checkHasLock();
        List list = this.listeners.computeIfAbsent(navigationHandler, key -> new ArrayList());
        list.add(listener);
        list.sort((o1, o2) -> {
            Class<?> o1Class = o1.getClass();
            Class<?> o2Class = o2.getClass();
            ListenerPriority listenerPriority1 = o1Class.getAnnotation(ListenerPriority.class);
            ListenerPriority listenerPriority2 = o2Class.getAnnotation(ListenerPriority.class);
            int priority1 = listenerPriority1 != null ? listenerPriority1.value() : 0;
            int priority2 = listenerPriority2 != null ? listenerPriority2.value() : 0;
            return Integer.compare(priority2, priority1);
        });
        return () -> list.remove(listener);
    }

    public <E> List<E> getNavigationListeners(Class<E> navigationHandler) {
        List registeredListeners = this.listeners.computeIfAbsent(navigationHandler, key -> new ArrayList());
        return Collections.unmodifiableList(registeredListeners);
    }

    public Page.ExecutionCanceler addJavaScriptInvocation(JavaScriptInvocation invocation) {
        this.session.checkHasLock();
        this.pendingJsInvocations.add(invocation);
        return () -> this.pendingJsInvocations.remove(invocation);
    }

    public List<JavaScriptInvocation> dumpPendingJavaScriptInvocations() {
        this.pendingTitleUpdateCanceler = null;
        if (this.pendingJsInvocations.isEmpty()) {
            return Collections.emptyList();
        }
        List<JavaScriptInvocation> currentList = this.pendingJsInvocations;
        this.pendingJsInvocations = new ArrayList<JavaScriptInvocation>();
        return currentList;
    }

    List<JavaScriptInvocation> getPendingJavaScriptInvocations() {
        return this.pendingJsInvocations;
    }

    public void setTitle(String title) {
        assert (title != null);
        JavaScriptInvocation invocation = new JavaScriptInvocation("document.title = $0", new Serializable[]{title});
        this.pendingTitleUpdateCanceler = this.addJavaScriptInvocation(invocation);
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean cancelPendingTitleUpdate() {
        if (this.pendingTitleUpdateCanceler == null) {
            return false;
        }
        boolean result = this.pendingTitleUpdateCanceler.cancelExecution();
        this.pendingTitleUpdateCanceler = null;
        return result;
    }

    public void showRouteTarget(Location viewLocation, String path, Component target, List<RouterLayout> layouts) {
        assert (target != null);
        assert (viewLocation != null);
        this.updateTheme(target, path);
        HasElement oldRoot = null;
        if (!this.routerTargetChain.isEmpty()) {
            oldRoot = this.routerTargetChain.get(this.routerTargetChain.size() - 1);
        }
        this.viewLocation = viewLocation;
        Element uiElement = this.ui.getElement();
        HashMap<RouterLayout, HasElement> oldChildren = new HashMap<RouterLayout, HasElement>();
        for (int i = 0; i < this.routerTargetChain.size() - 1; ++i) {
            HasElement child = this.routerTargetChain.get(i);
            RouterLayout parent = (RouterLayout)this.routerTargetChain.get(i + 1);
            oldChildren.put(parent, child);
        }
        this.routerTargetChain = new ArrayList();
        this.routerTargetChain.add(target);
        if (layouts != null) {
            this.routerTargetChain.addAll(layouts);
        }
        HasElement root = null;
        for (HasElement part : this.routerTargetChain) {
            if (root != null) {
                assert (part instanceof RouterLayout) : "All parts of the chain except the first must implement " + RouterLayout.class.getSimpleName();
                RouterLayout parent = (RouterLayout)part;
                HasElement oldChild = (HasElement)oldChildren.get(parent);
                if (oldChild != root) {
                    this.removeFromParent(oldChild);
                    parent.showRouterLayoutContent(root);
                }
            } else if (part instanceof RouterLayout && oldChildren.containsKey(part)) {
                this.removeFromParent((HasElement)oldChildren.get(part));
                ((RouterLayout)part).showRouterLayoutContent(null);
            }
            root = part;
        }
        if (root == null) {
            throw new IllegalArgumentException("Root can't be null here since we know there's at least one item in the chain");
        }
        Element rootElement = root.getElement();
        if (!uiElement.equals(rootElement.getParent())) {
            if (oldRoot != null) {
                oldRoot.getElement().removeFromParent();
            }
            rootElement.removeFromParent();
            uiElement.appendChild(rootElement);
        }
    }

    private void updateTheme(Component target, String path) {
        Optional<ThemeDefinition> themeDefinition = this.ui.getThemeFor(target.getClass(), path);
        if (themeDefinition.isPresent()) {
            Class<? extends AbstractTheme> themeClass = themeDefinition.get().getTheme();
            if (this.theme == null || !this.theme.getClass().equals(themeClass)) {
                this.theme = ReflectTools.createInstance(themeClass);
            }
        } else {
            this.theme = null;
            if (!AnnotationReader.getAnnotationFor(target.getClass(), NoTheme.class).isPresent()) {
                UIInternals.getLogger().warn("No @Theme defined for {}. See 'trace' level logs for the exact components missing theming.", (Object)target.getClass().getName());
            }
        }
    }

    private void removeFromParent(HasElement component) {
        if (component != null) {
            component.getElement().removeFromParent();
        }
    }

    public List<HasElement> getActiveRouterTargetsChain() {
        return Collections.unmodifiableList(this.routerTargetChain);
    }

    public Location getActiveViewLocation() {
        return this.viewLocation;
    }

    public VaadinSession getSession() {
        return this.session;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)UIInternals.class.getName());
    }

    public DependencyList getDependencyList() {
        return this.dependencyList;
    }

    public void addComponentDependencies(Class<? extends Component> componentClass) {
        Page page = this.ui.getPage();
        ComponentMetaData.DependencyInfo dependencies = ComponentUtil.getDependencies(this.session.getService(), componentClass);
        dependencies.getHtmlImports().forEach(html -> this.addHtmlImport((ComponentMetaData.HtmlImportDependency)html, page));
        dependencies.getJavaScripts().forEach(js -> page.addJavaScript(js.value(), js.loadMode()));
        dependencies.getStyleSheets().forEach(styleSheet -> page.addStyleSheet(styleSheet.value(), styleSheet.loadMode()));
    }

    private void addHtmlImport(ComponentMetaData.HtmlImportDependency dependency, Page page) {
        dependency.getUris().forEach(uri -> page.addHtmlImport(this.translateTheme((String)uri), dependency.getLoadMode()));
    }

    private String translateTheme(String importValue) {
        if (this.theme != null) {
            VaadinService service = this.session.getService();
            WebBrowser browser = this.session.getBrowser();
            Optional<String> themedUrl = service.getThemedUrl(importValue, browser, this.theme);
            return themedUrl.orElse(importValue);
        }
        Matcher componentMatcher = componentSource.matcher(importValue);
        if (componentMatcher.matches()) {
            String componentName = componentMatcher.group(1);
            UIInternals.getLogger().trace("Vaadin component '{}' is used and missing theme definition.", (Object)componentName);
        }
        return importValue;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public Location getLastHandledLocation() {
        return this.lastHandledNavigation;
    }

    public void setLastHandledNavigation(Location location) {
        this.lastHandledNavigation = location;
    }

    public boolean hasLastHandledLocation() {
        return this.lastHandledNavigation != null;
    }

    public void clearLastHandledNavigation() {
        this.setLastHandledNavigation(null);
    }

    public BeforeLeaveEvent.ContinueNavigationAction getContinueNavigationAction() {
        return this.continueNavigationAction;
    }

    public void setContinueNavigationAction(BeforeLeaveEvent.ContinueNavigationAction continueNavigationAction) {
        this.continueNavigationAction = continueNavigationAction;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public Router getRouter() {
        return this.getSession().getService().getRouter();
    }

    public boolean isDirty() {
        return this.getStateTree().isDirty() || !this.getPendingJavaScriptInvocations().isEmpty();
    }

    public void setContextRoot(String contextRootRelativePath) {
        this.contextRootRelativePath = contextRootRelativePath;
    }

    public String getContextRootRelativePath() {
        return this.contextRootRelativePath;
    }

    public UI getUI() {
        return this.ui;
    }

    public static class JavaScriptInvocation
    implements Serializable {
        private final String expression;
        private final List<Serializable> parameters = new ArrayList<Serializable>();

        public JavaScriptInvocation(String expression, Serializable ... parameters) {
            this.expression = expression;
            Collections.addAll(this.parameters, parameters);
        }

        public String getExpression() {
            return this.expression;
        }

        public List<Object> getParameters() {
            return Collections.unmodifiableList(this.parameters);
        }
    }
}

