/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.BrowserWindowResizeEvent;
import com.vaadin.flow.component.page.BrowserWindowResizeListener;
import com.vaadin.flow.component.page.History;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import java.io.Serializable;
import java.util.Objects;

public class Page
implements Serializable {
    private ResizeEventReceiver resizeReceiver;
    private final UI ui;
    private final History history;

    public Page(UI ui) {
        this.ui = ui;
        this.history = new History(ui);
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException("Cannot set a null page title.");
        }
        this.ui.getInternals().setTitle(title);
    }

    public void addStyleSheet(String url) {
        this.addStyleSheet(url, LoadMode.EAGER);
    }

    public void addStyleSheet(String url, LoadMode loadMode) {
        this.addDependency(new Dependency(Dependency.Type.STYLESHEET, url, loadMode));
    }

    public void addJavaScript(String url) {
        this.addJavaScript(url, LoadMode.EAGER);
    }

    public void addJavaScript(String url, LoadMode loadMode) {
        this.addDependency(new Dependency(Dependency.Type.JAVASCRIPT, url, loadMode));
    }

    public void addHtmlImport(String url) {
        this.addHtmlImport(url, LoadMode.EAGER);
    }

    public void addHtmlImport(String url, LoadMode loadMode) {
        this.addDependency(new Dependency(Dependency.Type.HTML_IMPORT, url, loadMode));
    }

    private void addDependency(Dependency dependency) {
        assert (dependency != null);
        this.ui.getInternals().getDependencyList().add(dependency);
    }

    public ExecutionCanceler executeJavaScript(String expression, Serializable ... parameters) {
        for (Serializable argument : parameters) {
            JsonCodec.encodeWithTypeInfo(argument);
        }
        UIInternals.JavaScriptInvocation invocation = new UIInternals.JavaScriptInvocation(expression, parameters);
        return this.ui.getInternals().addJavaScriptInvocation(invocation);
    }

    public History getHistory() {
        return this.history;
    }

    public void reload() {
        this.executeJavaScript("window.location.reload();", new Serializable[0]);
    }

    public Registration addBrowserWindowResizeListener(BrowserWindowResizeListener resizeListener) {
        Objects.requireNonNull(resizeListener);
        if (this.resizeReceiver == null) {
            this.resizeReceiver = new ResizeEventReceiver();
            this.ui.getElement().appendVirtualChild(this.resizeReceiver.getElement());
        }
        if (this.resizeReceiver.windowResizeListenersSize == 0) {
            this.executeJavaScript(LazyJsLoader.WINDOW_LISTENER_JS, this.resizeReceiver);
        }
        return this.resizeReceiver.addListener(resizeListener);
    }

    private static class LazyJsLoader
    implements Serializable {
        private static final String JS_FILE_NAME = "windowResizeListener.js";
        private static final String WINDOW_LISTENER_JS = LazyJsLoader.readJS();

        private LazyJsLoader() {
        }

        /*
         * Exception decompiling
         */
        private static String readJS() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    @FunctionalInterface
    public static interface ExecutionCanceler
    extends Serializable {
        public boolean cancelExecution();
    }

    private static class ResizeRegistration
    implements Registration {
        private boolean isInvoked;
        private final Registration origin;
        private final ResizeEventReceiver receiver;

        private ResizeRegistration(ResizeEventReceiver receiver, Registration origin) {
            this.origin = origin;
            this.receiver = receiver;
        }

        @Override
        public void remove() {
            if (this.isInvoked) {
                return;
            }
            this.origin.remove();
            this.receiver.listenerIsUnregistered();
            this.isInvoked = true;
        }
    }

    private static class ResizeEvent
    extends ComponentEvent<ResizeEventReceiver> {
        private final BrowserWindowResizeEvent apiEvent;

        private ResizeEvent(ResizeEventReceiver source, int width, int height) {
            super(source, true);
            this.apiEvent = new BrowserWindowResizeEvent(source.getUI().get().getPage(), width, height);
        }

        private BrowserWindowResizeEvent getApiEvent() {
            return this.apiEvent;
        }
    }

    @Tag(value="div")
    private static class ResizeEventReceiver
    extends Component {
        private int windowResizeListenersSize;

        private ResizeEventReceiver() {
        }

        @ClientCallable
        private void windowResized(int width, int height) {
            if (this.windowResizeListenersSize != 0) {
                this.fireEvent(new ResizeEvent(this, width, height));
            }
        }

        private Registration addListener(BrowserWindowResizeListener listener) {
            ++this.windowResizeListenersSize;
            Registration registration = this.addListener(ResizeEvent.class, event -> listener.browserWindowResized(((ResizeEvent)event).getApiEvent()));
            return new ResizeRegistration(this, registration);
        }

        private void listenerIsUnregistered() {
            --this.windowResizeListenersSize;
            if (this.windowResizeListenersSize == 0) {
                this.getUI().get().getPage().executeJavaScript("$0.resizeRemove()", this);
            }
        }
    }
}

