/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.server.DefaultDeploymentConfiguration;
import com.vaadin.flow.server.VaadinServletConfiguration;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public final class DeploymentConfigurationFactory
implements Serializable {
    private DeploymentConfigurationFactory() {
    }

    public static DeploymentConfiguration createDeploymentConfiguration(Class<?> systemPropertyBaseClass, ServletConfig servletConfig) throws ServletException {
        return new DefaultDeploymentConfiguration(systemPropertyBaseClass, DeploymentConfigurationFactory.createInitParameters(systemPropertyBaseClass, servletConfig));
    }

    private static Properties createInitParameters(Class<?> systemPropertyBaseClass, ServletConfig servletConfig) throws ServletException {
        String name;
        Properties initParameters = new Properties();
        DeploymentConfigurationFactory.readUiFromEnclosingClass(systemPropertyBaseClass, initParameters);
        DeploymentConfigurationFactory.readConfigurationAnnotation(systemPropertyBaseClass, initParameters);
        ServletContext context = servletConfig.getServletContext();
        Enumeration e = context.getInitParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            initParameters.setProperty(name, context.getInitParameter(name));
        }
        e = servletConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            initParameters.setProperty(name, servletConfig.getInitParameter(name));
        }
        return initParameters;
    }

    private static void readUiFromEnclosingClass(Class<?> systemPropertyBaseClass, Properties initParameters) {
        Class<?> enclosingClass = systemPropertyBaseClass.getEnclosingClass();
        if (enclosingClass != null && UI.class.isAssignableFrom(enclosingClass)) {
            initParameters.put("UI", enclosingClass.getName());
        }
    }

    private static void readConfigurationAnnotation(Class<?> systemPropertyBaseClass, Properties initParameters) throws ServletException {
        Optional<VaadinServletConfiguration> optionalConfigAnnotation = AnnotationReader.getAnnotationFor(systemPropertyBaseClass, VaadinServletConfiguration.class);
        if (optionalConfigAnnotation.isPresent()) {
            Method[] methods;
            VaadinServletConfiguration configuration = optionalConfigAnnotation.get();
            for (Method method : methods = VaadinServletConfiguration.class.getDeclaredMethods()) {
                VaadinServletConfiguration.InitParameterName name = method.getAnnotation(VaadinServletConfiguration.InitParameterName.class);
                assert (name != null) : "All methods declared in VaadinServletConfiguration should have a @InitParameterName annotation";
                try {
                    Object value = method.invoke((Object)configuration, new Object[0]);
                    String stringValue = value instanceof Class ? ((Class)value).getName() : value.toString();
                    initParameters.setProperty(name.value(), stringValue);
                }
                catch (Exception e) {
                    throw new ServletException("Could not read @VaadinServletConfiguration value " + method.getName(), (Throwable)e);
                }
            }
        }
    }
}

