/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Key;
import java.util.List;
import java.util.stream.Stream;

public enum KeyModifier implements Key
{
    SHIFT(Key.SHIFT),
    CONTROL(Key.CONTROL),
    ALT(Key.ALT),
    META(Key.META);

    private final Key key;

    private KeyModifier(Key key) {
        this.key = key;
    }

    @Override
    public List<String> getKeys() {
        return this.key.getKeys();
    }

    public static KeyModifier of(String key) {
        return Stream.of(KeyModifier.values()).filter(k -> k.matches(key)).findFirst().orElseThrow(IllegalArgumentException::new);
    }
}

