/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.polymertemplate.EventHandler;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ClientCallableHandlers;
import com.vaadin.flow.internal.nodefeature.ComponentMapping;
import com.vaadin.flow.internal.nodefeature.PolymerServerEventHandlers;
import com.vaadin.flow.server.communication.rpc.AbstractRpcInvocationHandler;
import com.vaadin.flow.server.communication.rpc.DefaultRpcDecoder;
import com.vaadin.flow.server.communication.rpc.RpcDecodeException;
import com.vaadin.flow.server.communication.rpc.RpcDecoder;
import com.vaadin.flow.server.communication.rpc.StringToEnumDecoder;
import com.vaadin.flow.server.communication.rpc.StringToNumberDecoder;
import com.vaadin.flow.templatemodel.ModelType;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import elemental.json.JsonValue;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

public class PublishedServerEventHandlerRpcHandler
extends AbstractRpcInvocationHandler {
    private static final Collection<RpcDecoder> DECODERS = PublishedServerEventHandlerRpcHandler.loadDecoders();

    @Override
    public String getRpcType() {
        return "publishedEventHandler";
    }

    @Override
    public Optional<Runnable> handleNode(StateNode node, JsonObject invocationJson) {
        assert (invocationJson.hasKey("templateEventMethodName"));
        String methodName = invocationJson.getString("templateEventMethodName");
        if (methodName == null) {
            throw new IllegalArgumentException("Event handler method name may not be null");
        }
        JsonValue args = invocationJson.get("templateEventMethodArgs");
        if (args == null) {
            args = Json.createArray();
        }
        if (args.getType() != JsonType.ARRAY) {
            throw new IllegalArgumentException("Incorrect type for method arguments: " + args.getClass());
        }
        assert (node.hasFeature(ComponentMapping.class));
        Optional<Component> component = node.getFeature(ComponentMapping.class).getComponent();
        if (!component.isPresent()) {
            throw new IllegalStateException("Unable to handle RPC template event JSON message: there is no component available for the target node");
        }
        boolean execute = node.isEnabled();
        if (!execute) {
            ClientCallableHandlers clientDelegate = node.getFeature(ClientCallableHandlers.class);
            PolymerServerEventHandlers eventHandlers = node.getFeature(PolymerServerEventHandlers.class);
            if (clientDelegate.hasHandler(methodName)) {
                execute = DisabledUpdateMode.ALWAYS.equals((Object)clientDelegate.getDisabledUpdateMode(methodName));
            }
            if (eventHandlers.hasHandler(methodName)) {
                boolean bl = execute = execute || DisabledUpdateMode.ALWAYS.equals((Object)eventHandlers.getDisabledUpdateMode(methodName));
            }
        }
        if (execute) {
            PublishedServerEventHandlerRpcHandler.invokeMethod(component.get(), component.get().getClass(), methodName, (JsonArray)args);
        }
        return Optional.empty();
    }

    static void invokeMethod(Component instance, Class<?> clazz, String methodName, JsonArray args) {
        assert (instance != null);
        Optional<Method> method = PublishedServerEventHandlerRpcHandler.findMethod(instance, clazz, methodName);
        if (method.isPresent()) {
            PublishedServerEventHandlerRpcHandler.invokeMethod(instance, method.get(), args);
        } else if (instance instanceof Composite) {
            Object compositeContent = ((Composite)instance).getContent();
            PublishedServerEventHandlerRpcHandler.invokeMethod(compositeContent, compositeContent.getClass(), methodName, args);
        } else {
            String msg = String.format("Neither class '%s' nor its super classes declare event handler method '%s'", instance.getClass().getName(), methodName);
            throw new IllegalStateException(msg);
        }
    }

    private static Optional<Method> findMethod(Component instance, Class<?> clazz, String methodName) {
        List methods = Stream.of(clazz.getDeclaredMethods()).filter(method -> methodName.equals(method.getName())).filter(method -> method.isAnnotationPresent(EventHandler.class) || method.isAnnotationPresent(ClientCallable.class)).collect(Collectors.toList());
        if (methods.size() > 1) {
            String msg = String.format("Class '%s' contains several event handler method with the same name '%s'", instance.getClass().getName(), methodName);
            throw new IllegalStateException(msg);
        }
        if (methods.size() == 1) {
            return Optional.of(methods.get(0));
        }
        if (!Component.class.equals(clazz)) {
            return PublishedServerEventHandlerRpcHandler.findMethod(instance, clazz.getSuperclass(), methodName);
        }
        return Optional.empty();
    }

    private static void invokeMethod(Component instance, Method method, JsonArray args) {
        try {
            method.setAccessible(true);
            method.invoke((Object)instance, PublishedServerEventHandlerRpcHandler.decodeArgs(instance, method, args));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            LoggerFactory.getLogger((String)PublishedServerEventHandlerRpcHandler.class.getName()).debug(null, (Throwable)e);
            throw new RuntimeException(e.getCause());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Object[] decodeArgs(Component instance, Method method, JsonArray argsFromClient) {
        JsonArray argValues;
        int methodArgs = method.getParameterCount();
        int clientValuesCount = argsFromClient.length();
        if (method.isVarArgs()) {
            if (clientValuesCount < methodArgs - 1) {
                String msg = String.format("The number of received values (%d) is not enough to call the method '%s' declared in '%s' which has vararg parameter and the number of arguments %d", argsFromClient.length(), method.getName(), method.getDeclaringClass().getName(), method.getParameterCount());
                throw new IllegalArgumentException(msg);
            }
            argValues = PublishedServerEventHandlerRpcHandler.unwrapVarArgs(argsFromClient, method);
        } else {
            if (methodArgs != clientValuesCount) {
                String msg = String.format("The number of received values (%d) is not equal to the number of arguments (%d) in the method '%s' declared in '%s'", argsFromClient.length(), method.getParameterCount(), method.getName(), method.getDeclaringClass().getName());
                throw new IllegalArgumentException(msg);
            }
            argValues = argsFromClient;
        }
        ArrayList<Object> decoded = new ArrayList<Object>(method.getParameterCount());
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        int i = 0;
        while (i < argValues.length()) {
            Class<?> type = methodParameterTypes[i];
            decoded.add(PublishedServerEventHandlerRpcHandler.decodeArg(instance, method, type, i, argValues.get(i)));
            ++i;
        }
        return decoded.toArray(new Object[method.getParameterCount()]);
    }

    private static JsonArray unwrapVarArgs(JsonArray argsFromClient, Method method) {
        int paramCount = method.getParameterCount();
        if (argsFromClient.length() == paramCount && argsFromClient.get(paramCount - 1).getType().equals((Object)JsonType.ARRAY)) {
            return argsFromClient;
        }
        JsonArray result = Json.createArray();
        JsonArray rest = Json.createArray();
        int newIndex = 0;
        for (int i = 0; i < argsFromClient.length(); ++i) {
            JsonValue value = argsFromClient.get(i);
            if (i < paramCount - 1) {
                result.set(i, value);
                continue;
            }
            rest.set(newIndex, value);
            ++newIndex;
        }
        result.set(paramCount - 1, (JsonValue)rest);
        return result;
    }

    private static Object decodeArg(Component instance, Method method, Class<?> type, int index, JsonValue argValue) {
        assert (argValue != null);
        if (type.isPrimitive() && argValue.getType() == JsonType.NULL) {
            String msg = String.format("Null values are not allowed for primitive types but a 'null' value was received for parameter %d which refers to primitive type '%s' in the method '%s' defined in the class '%s'", index, type.getName(), method.getName(), method.getDeclaringClass().getName());
            throw new IllegalArgumentException(msg);
        }
        if (type.isArray()) {
            return PublishedServerEventHandlerRpcHandler.decodeArray(method, type, index, argValue);
        }
        Class<?> convertedType = ReflectTools.convertPrimitiveType(type);
        if (PublishedServerEventHandlerRpcHandler.isTemplateModelValue(instance, argValue, convertedType)) {
            return PublishedServerEventHandlerRpcHandler.getTemplateItem((PolymerTemplate)instance, (JsonObject)argValue, method.getGenericParameterTypes()[index]);
        }
        Optional<RpcDecoder> decoder = PublishedServerEventHandlerRpcHandler.getDecoder(argValue, convertedType);
        if (decoder.isPresent()) {
            try {
                return decoder.get().decode(argValue, convertedType);
            }
            catch (RpcDecodeException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        String msg = String.format("Class '%s' has the method '%s' whose parameter %d refers to unsupported type '%s'", method.getDeclaringClass().getName(), method.getName(), index, type.getName());
        throw new IllegalArgumentException(msg);
    }

    private static Optional<RpcDecoder> getDecoder(JsonValue value, Class<?> type) {
        return DECODERS.stream().filter(decoder -> decoder.isApplicable(value, type)).findFirst();
    }

    private static boolean isTemplateModelValue(Component instance, JsonValue argValue, Class<?> convertedType) {
        return instance instanceof PolymerTemplate && argValue instanceof JsonObject && ((PolymerTemplate)instance).isSupportedClass(convertedType) && ((JsonObject)argValue).hasKey("nodeId");
    }

    private static Object getTemplateItem(PolymerTemplate<?> template, JsonObject argValue, Type convertedType) {
        StateNode node = template.getUI().get().getInternals().getStateTree().getNodeById((int)argValue.getNumber("nodeId"));
        ModelType propertyType = template.getModelType(convertedType);
        return propertyType.modelToApplication(node);
    }

    private static Object decodeArray(Method method, Class<?> type, int index, JsonValue argValue) {
        if (argValue.getType() != JsonType.ARRAY) {
            String msg = String.format("Class '%s' has the method '%s' whose parameter %d refers to the array type '%s' but received value is not an array, its type is '%s'", method.getDeclaringClass().getName(), method.getName(), index, type.getName(), argValue.getType().name());
            throw new IllegalArgumentException(msg);
        }
        Class<?> componentType = type.getComponentType();
        JsonArray array = (JsonArray)argValue;
        Object result = Array.newInstance(componentType, array.length());
        for (int i = 0; i < array.length(); ++i) {
            Array.set(result, i, PublishedServerEventHandlerRpcHandler.decodeArg(null, method, componentType, index, array.get(i)));
        }
        return result;
    }

    private static Collection<RpcDecoder> loadDecoders() {
        ArrayList<RpcDecoder> decoders = new ArrayList<RpcDecoder>();
        decoders.add(new StringToNumberDecoder());
        decoders.add(new StringToEnumDecoder());
        decoders.add(new DefaultRpcDecoder());
        return decoders;
    }
}

