/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseWriter
implements Serializable {
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private final int bufferSize;

    public ResponseWriter() {
        this(32768);
    }

    public ResponseWriter(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponseContents(String filenameWithPath, URL resourceUrl, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.writeContentType(filenameWithPath, (ServletRequest)request, (ServletResponse)response);
        URLConnection connection = null;
        InputStream dataStream = null;
        if (this.acceptsGzippedResource(request)) {
            String gzippedFilenameWithPath = filenameWithPath + ".gz";
            try {
                URL url = request.getServletContext().getResource(gzippedFilenameWithPath);
                if (url != null) {
                    connection = url.openConnection();
                    dataStream = connection.getInputStream();
                    response.setHeader("Content-Encoding", "gzip");
                }
            }
            catch (Exception e) {
                this.getLogger().debug("Unexpected exception looking for gzipped resource {}", (Object)gzippedFilenameWithPath, (Object)e);
            }
        }
        if (dataStream == null) {
            connection = resourceUrl.openConnection();
            dataStream = connection.getInputStream();
        }
        try {
            long length = connection.getContentLengthLong();
            if (length >= 0L) {
                response.setContentLengthLong(length);
            }
        }
        catch (Exception e) {
            this.getLogger().debug("Error setting the content length", (Throwable)e);
        }
        try {
            this.writeStream(response.getOutputStream(), dataStream);
        }
        catch (IOException e) {
            this.getLogger().debug("Error writing static file to user", (Throwable)e);
        }
        finally {
            try {
                dataStream.close();
            }
            catch (IOException e) {
                this.getLogger().debug("Error closing input stream for resource", (Throwable)e);
            }
        }
    }

    private void writeStream(ServletOutputStream outputStream, InputStream inputStream) throws IOException {
        int bytes;
        byte[] buffer = new byte[this.bufferSize];
        while ((bytes = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, bytes);
        }
    }

    protected boolean acceptsGzippedResource(HttpServletRequest request) {
        String accept = request.getHeader("Accept-Encoding");
        if (accept == null) {
            return false;
        }
        if ((accept = accept.replace(" ", "")).contains("gzip")) {
            return !ResponseWriter.isQZero(accept, "gzip");
        }
        return accept.contains("*") && !ResponseWriter.isQZero(accept, "*");
    }

    void writeContentType(String filenameWithPath, ServletRequest request, ServletResponse response) {
        String mimetype = request.getServletContext().getMimeType(filenameWithPath);
        if (mimetype != null) {
            response.setContentType(mimetype);
        }
    }

    private static boolean isQZero(String acceptEncoding, String encoding) {
        String qPrefix = encoding + ";q=";
        int qValueIndex = acceptEncoding.indexOf(qPrefix);
        if (qValueIndex == -1) {
            return false;
        }
        String qValue = acceptEncoding.substring(qValueIndex + qPrefix.length());
        int endOfQValue = qValue.indexOf(44);
        if (endOfQValue != -1) {
            qValue = qValue.substring(0, endOfQValue);
        }
        return Objects.equals("0", qValue) || Objects.equals("0.0", qValue) || Objects.equals("0.00", qValue) || Objects.equals("0.000", qValue);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger((String)this.getClass().getName());
    }
}

