/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.History;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import java.io.Serializable;

public class Page
implements Serializable {
    private final UI ui;
    private final History history;

    public Page(UI ui) {
        this.ui = ui;
        this.history = new History(ui);
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException("Cannot set a null page title.");
        }
        this.ui.getInternals().setTitle(title);
    }

    public void addStyleSheet(String url) {
        this.addStyleSheet(url, LoadMode.EAGER);
    }

    public void addStyleSheet(String url, LoadMode loadMode) {
        this.addDependency(new Dependency(Dependency.Type.STYLESHEET, url, loadMode));
    }

    public void addJavaScript(String url) {
        this.addJavaScript(url, LoadMode.EAGER);
    }

    public void addJavaScript(String url, LoadMode loadMode) {
        this.addDependency(new Dependency(Dependency.Type.JAVASCRIPT, url, loadMode));
    }

    public void addHtmlImport(String url) {
        this.addHtmlImport(url, LoadMode.EAGER);
    }

    public void addHtmlImport(String url, LoadMode loadMode) {
        this.addDependency(new Dependency(Dependency.Type.HTML_IMPORT, url, loadMode));
    }

    private void addDependency(Dependency dependency) {
        assert (dependency != null);
        this.ui.getInternals().getDependencyList().add(dependency);
    }

    public ExecutionCanceler executeJavaScript(String expression, Serializable ... parameters) {
        for (Serializable argument : parameters) {
            JsonCodec.encodeWithTypeInfo(argument);
        }
        UIInternals.JavaScriptInvocation invocation = new UIInternals.JavaScriptInvocation(expression, parameters);
        return this.ui.getInternals().addJavaScriptInvocation(invocation);
    }

    public History getHistory() {
        return this.history;
    }

    public void reload() {
        this.executeJavaScript("window.location.reload();", new Serializable[0]);
    }

    @FunctionalInterface
    public static interface ExecutionCanceler
    extends Serializable {
        public boolean cancelExecution();
    }
}

