/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.dom.Element;
import java.util.Iterator;
import java.util.stream.Stream;

public interface HasOrderedComponents<T extends Component>
extends HasComponents {
    default public void replace(Component oldComponent, Component newComponent) {
        if (oldComponent == null && newComponent == null) {
            return;
        }
        if (oldComponent == null) {
            this.add(newComponent);
        } else if (newComponent == null) {
            this.remove(oldComponent);
        } else {
            Element element = this.getElement();
            int oldIndex = element.indexOfChild(oldComponent.getElement());
            int newIndex = element.indexOfChild(newComponent.getElement());
            if (oldIndex >= 0 && newIndex >= 0) {
                element.insertChild(oldIndex, newComponent.getElement());
                element.insertChild(newIndex, oldComponent.getElement());
            } else if (oldIndex >= 0) {
                element.setChild(oldIndex, newComponent.getElement());
            } else {
                this.add(newComponent);
            }
        }
    }

    default public int indexOf(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("The 'component' parameter cannot be null");
        }
        Iterator it = ((Stream)((Component)((Object)this)).getChildren().sequential()).iterator();
        int index = 0;
        while (it.hasNext()) {
            Component next = (Component)it.next();
            if (component.equals(next)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    default public int getComponentCount() {
        return (int)((Component)((Object)this)).getChildren().count();
    }

    default public Component getComponentAt(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("The 'index' argument should be greater than 0. It was: " + index);
        }
        return (Component)((Stream)((Component)((Object)this)).getChildren().sequential()).skip(index).findFirst().orElseThrow(() -> new IllegalArgumentException("The 'index' argument should not be greater than or equals to the number of children components. It was: " + index));
    }
}

