/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasEnabled;
import java.util.Objects;

public interface HasComponents
extends HasElement,
HasEnabled {
    default public void add(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to add cannot be null");
            this.getElement().appendChild(component.getElement());
        }
    }

    default public void remove(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to remove cannot be null");
            if (!this.getElement().equals(component.getElement().getParent())) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            this.getElement().removeChild(component.getElement());
        }
    }

    default public void removeAll() {
        this.getElement().removeAllChildren();
    }
}

