/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventBusUtil;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DebounceSettings;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.dom.DebouncePhase;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class ComponentEventBus
implements Serializable {
    HashMap<Class<? extends ComponentEvent<?>>, ComponentEventData> componentEventData = new HashMap();
    private Component component;

    public ComponentEventBus(Component component) {
        this.component = component;
    }

    public <T extends ComponentEvent<?>> Registration addListener(Class<T> eventType, ComponentEventListener<T> listener) {
        this.addDomTriggerIfNeeded(eventType);
        List listeners = this.componentEventData.computeIfAbsent(eventType, t -> new ComponentEventData()).listeners;
        listeners.add(listener);
        return () -> this.removeListener(eventType, listener);
    }

    public boolean hasListener(Class<? extends ComponentEvent> eventType) {
        if (eventType == null) {
            throw new IllegalArgumentException("Event type cannot be null");
        }
        return this.componentEventData.containsKey(eventType);
    }

    public void fireEvent(ComponentEvent event) {
        Class<?> eventType = event.getClass();
        if (!this.hasListener(eventType)) {
            return;
        }
        List listeners = this.componentEventData.get(event.getClass()).listeners;
        for (ComponentEventListener l : new ArrayList(listeners)) {
            event.setUnregisterListenerCommand(() -> this.removeListener(eventType, l));
            l.onComponentEvent(event);
            event.setUnregisterListenerCommand(null);
        }
    }

    private void addDomTriggerIfNeeded(Class<? extends ComponentEvent<?>> eventType) {
        boolean alreadyRegistered = this.hasListener(eventType);
        if (alreadyRegistered) {
            return;
        }
        AnnotationReader.getAnnotationFor(eventType, DomEvent.class).ifPresent(annotation -> this.addDomTrigger(eventType, (DomEvent)annotation));
    }

    private void addDomTrigger(Class<? extends ComponentEvent<?>> eventType, DomEvent annotation) {
        assert (eventType != null);
        assert (!this.componentEventData.containsKey(eventType) || this.componentEventData.get(eventType).domEventRemover == null);
        assert (annotation != null);
        String domEventType = annotation.value();
        DisabledUpdateMode mode = annotation.allowUpdates();
        String filter = annotation.filter();
        DebounceSettings debounce = annotation.debounce();
        int debounceTimeout = debounce.timeout();
        if (domEventType == null || domEventType.isEmpty()) {
            throw new IllegalArgumentException("The DOM event type cannot be null or empty");
        }
        Element element = this.component.getElement();
        DomListenerRegistration registration = element.addEventListener(domEventType, event -> this.handleDomEvent(eventType, event));
        registration.setDisabledUpdateMode(mode);
        LinkedHashMap<String, Class<?>> eventDataExpressions = ComponentEventBusUtil.getEventDataExpressions(eventType);
        eventDataExpressions.keySet().forEach(registration::addEventData);
        if (!"".equals(filter)) {
            registration.setFilter(filter);
        }
        if (debounceTimeout != 0) {
            DebouncePhase[] phases = debounce.phases();
            if (phases.length == 0) {
                throw new IllegalStateException("There must be at least one debounce phase");
            }
            DebouncePhase[] rest = new DebouncePhase[phases.length - 1];
            System.arraycopy(phases, 1, rest, 0, rest.length);
            registration.debounce(debounceTimeout, phases[0], rest);
        }
        this.componentEventData.computeIfAbsent(eventType, t -> new ComponentEventData()).domEventRemover = registration;
    }

    private List<Object> createEventDataObjects(com.vaadin.flow.dom.DomEvent domEvent, Class<? extends ComponentEvent<?>> eventType) {
        ArrayList<Object> eventDataObjects = new ArrayList<Object>();
        LinkedHashMap<String, Class<?>> expressions = ComponentEventBusUtil.getEventDataExpressions(eventType);
        expressions.forEach((expression, type) -> {
            JsonValue jsonValue = domEvent.getEventData().get(expression);
            if (jsonValue == null) {
                jsonValue = Json.createNull();
            }
            Object value = JsonCodec.decodeAs(jsonValue, type);
            eventDataObjects.add(value);
        });
        return eventDataObjects;
    }

    private <T extends ComponentEvent<?>> void removeListener(Class<T> eventType, ComponentEventListener<T> listener) {
        assert (eventType != null);
        assert (listener != null);
        ComponentEventData eventData = this.componentEventData.get(eventType);
        if (eventData == null) {
            throw new IllegalArgumentException("No listener of the given type is registered");
        }
        List listeners = eventData.listeners;
        assert (listeners != null);
        if (!listeners.remove(listener)) {
            throw new IllegalArgumentException("The given listener is not registered");
        }
        if (listeners.isEmpty()) {
            AnnotationReader.getAnnotationFor(eventType, DomEvent.class).ifPresent(annotation -> this.unregisterDomEvent(eventType, annotation.value()));
            this.componentEventData.remove(eventType);
        }
    }

    private void unregisterDomEvent(Class<? extends ComponentEvent<?>> eventType, String domEventType) {
        assert (eventType != null);
        assert (domEventType != null && !domEventType.isEmpty());
        Registration domEventRemover = this.componentEventData.get(eventType).domEventRemover;
        if (domEventRemover == null) {
            throw new IllegalArgumentException("No remover found when unregistering event type " + eventType.getName() + " from DOM event " + domEventType);
        }
        domEventRemover.remove();
        this.componentEventData.get(eventType).domEventRemover = null;
    }

    private void handleDomEvent(Class<? extends ComponentEvent<?>> eventType, com.vaadin.flow.dom.DomEvent domEvent) {
        ComponentEvent<?> e = this.createEventForDomEvent(eventType, domEvent, this.component);
        this.fireEvent(e);
    }

    private <T extends ComponentEvent<?>> T createEventForDomEvent(Class<T> eventType, com.vaadin.flow.dom.DomEvent domEvent, Component source) {
        try {
            Constructor<T> c = ComponentEventBusUtil.getEventConstructor(eventType);
            if (!c.getParameterTypes()[0].isAssignableFrom(source.getClass())) {
                Class<?> definedSourceType = c.getParameterTypes()[0];
                throw new IllegalArgumentException(String.format("The event type %s define the source type to be %s, which is not compatible with the used source of type %s", eventType.getName(), definedSourceType.getName(), source.getClass().getName()));
            }
            List<Object> eventData = this.createEventDataObjects(domEvent, eventType);
            Object[] params = new Object[eventData.size() + 2];
            params[0] = source;
            params[1] = Boolean.TRUE;
            for (int i = 0; i < eventData.size(); ++i) {
                params[i + 2] = eventData.get(i);
            }
            return (T)((ComponentEvent)c.newInstance(params));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to create an event object of type " + eventType.getName(), e);
        }
    }

    private static class ComponentEventData
    implements Serializable {
        private Registration domEventRemover = null;
        private List<ComponentEventListener<? extends ComponentEvent<?>>> listeners = new ArrayList(1);

        private ComponentEventData() {
        }
    }
}

