/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webjar;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.ResponseWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebJarServer
implements Serializable {
    private final ResponseWriter responseWriter = new ResponseWriter();
    private final String prefix;
    private final Pattern urlPattern;

    public WebJarServer(DeploymentConfiguration deploymentConfiguration) {
        assert (deploymentConfiguration != null);
        String frontendPrefix = deploymentConfiguration.getDevelopmentFrontendPrefix();
        if (!frontendPrefix.endsWith("/")) {
            throw new IllegalArgumentException("Frontend prefix must end with a /. Got \"" + frontendPrefix + "\"");
        }
        if (!frontendPrefix.startsWith("context://")) {
            throw new IllegalArgumentException("Cannot host WebJars for a fronted prefix that isn't relative to 'context://'. Current frontend prefix: " + frontendPrefix);
        }
        this.prefix = "/" + frontendPrefix.substring("context://".length()) + "bower_components/";
        this.urlPattern = Pattern.compile("^([/.]?[/..]*)" + this.prefix);
    }

    public boolean tryServeWebJarResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInContext = request.getServletPath() + request.getPathInfo();
        String webJarPath = this.getWebJarPath(pathInContext);
        if (webJarPath == null) {
            return false;
        }
        URL resourceUrl = request.getServletContext().getResource(webJarPath);
        if (resourceUrl == null) {
            return false;
        }
        this.responseWriter.writeResponseContents(webJarPath, resourceUrl, request, response);
        return true;
    }

    public Optional<String> getWebJarResourcePath(String filePathInContext) {
        String webJarPath = null;
        Matcher matcher = this.urlPattern.matcher(filePathInContext);
        if (matcher.find()) {
            webJarPath = this.getWebJarPath(filePathInContext.substring(matcher.group(1).length()));
        }
        return Optional.ofNullable(webJarPath);
    }

    private String getWebJarPath(String path) {
        if (!path.startsWith(this.prefix)) {
            return null;
        }
        return path.replace(this.prefix, "/webjars/");
    }
}

