/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.templatemodel;

import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.templatemodel.AllowClientUpdates;
import com.vaadin.flow.templatemodel.BeanModelType;
import com.vaadin.flow.templatemodel.ClientUpdateMode;
import com.vaadin.flow.templatemodel.Encode;
import com.vaadin.flow.templatemodel.InvalidTemplateModelException;
import com.vaadin.flow.templatemodel.ModelEncoder;
import com.vaadin.flow.templatemodel.ModelType;
import com.vaadin.flow.templatemodel.PathLookup;
import com.vaadin.flow.templatemodel.PropertyFilter;
import com.vaadin.flow.templatemodel.TemplateModelUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Deprecated
class PropertyMapBuilder {
    private final Map<String, BeanModelType.BeanModelTypeProperty> properties;

    PropertyMapBuilder(Class<?> javaType, PropertyFilter propertyFilter, PathLookup<ModelEncoder<?, ?>> converterLookup, PathLookup<ClientUpdateMode> updateModeLookup) {
        assert (javaType != null);
        assert (propertyFilter != null);
        this.properties = Stream.concat(this.getPropertiesData(ReflectTools.getGetterMethods(javaType), true, propertyFilter), this.getPropertiesData(ReflectTools.getSetterMethods(javaType), false, propertyFilter)).collect(Collectors.toMap(PropertyData::getPropertyName, Function.identity(), PropertyData::merge)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((PropertyData)entry.getValue()).buildProperty(propertyFilter, converterLookup, updateModeLookup)));
    }

    Map<String, BeanModelType.BeanModelTypeProperty> getProperties() {
        return this.properties;
    }

    private Stream<PropertyData> getPropertiesData(Stream<Method> methods, boolean getterMethods, PropertyFilter propertyFilter) {
        return methods.map(getter -> new PropertyData((Method)getter, getterMethods)).filter(data -> propertyFilter.test(data.getPropertyName()));
    }

    private static class PropertyData {
        private final String propertyName;
        private final Type propertyType;
        private final Class<?> declaringClass;
        private final Collection<Method> accessors = new ArrayList<Method>();
        private boolean hasGetter;

        private PropertyData(Method method, boolean isGetter) {
            this.propertyName = ReflectTools.getPropertyName((Method)method);
            this.propertyType = ReflectTools.getPropertyType((Method)method);
            this.declaringClass = method.getDeclaringClass();
            this.accessors.add(method);
            this.hasGetter = isGetter;
        }

        private PropertyData merge(PropertyData newData) {
            assert (Objects.equals(this.propertyName, newData.propertyName)) : String.format("This object is expected to be merged for objects with same 'propertyName' field, but got different ones: '%s' and '%s'", this.propertyName, newData.propertyName);
            this.accessors.addAll(newData.accessors);
            if (!this.hasGetter) {
                this.hasGetter = newData.hasGetter;
            }
            return this;
        }

        private BeanModelType.BeanModelTypeProperty buildProperty(PropertyFilter propertyFilter, PathLookup<ModelEncoder<?, ?>> outerConverters, PathLookup<ClientUpdateMode> outerClientModes) {
            PropertyFilter innerFilter = new PropertyFilter(propertyFilter, this.propertyName, this.getExcludeFieldsFilter());
            String prefix = innerFilter.getPrefix();
            PathLookup<ModelEncoder<?, ?>> innerConverters = outerConverters.compose(this.getModelConverters(), prefix);
            PathLookup<ClientUpdateMode> innerUpdateModes = outerClientModes.compose(this.getClientUpdateModes(), prefix);
            return new BeanModelType.BeanModelTypeProperty(this.createModelType(innerFilter, innerConverters, innerUpdateModes), innerUpdateModes.getItem(prefix).orElse(null), this.hasGetter);
        }

        private ModelType createModelType(PropertyFilter innerFilter, PathLookup<ModelEncoder<?, ?>> innerConverters, PathLookup<ClientUpdateMode> innerUpdateModes) {
            if (innerConverters.getItem(innerFilter.getPrefix()).isPresent()) {
                return BeanModelType.getConvertedModelType(this.propertyType, innerFilter, this.propertyName, this.declaringClass, innerConverters, innerUpdateModes);
            }
            return BeanModelType.getModelType(this.propertyType, innerFilter, this.propertyName, this.declaringClass, innerConverters, innerUpdateModes);
        }

        private Map<String, ModelEncoder<?, ?>> getModelConverters() {
            return this.collectAnnotationsByPath(Encode.class, Encode::path, convert -> (ModelEncoder)ReflectTools.createInstance(convert.value()), "converters");
        }

        private Map<String, ClientUpdateMode> getClientUpdateModes() {
            return this.collectAnnotationsByPath(AllowClientUpdates.class, AllowClientUpdates::path, AllowClientUpdates::value, "client update modes");
        }

        private <T, A extends Annotation> Map<String, T> collectAnnotationsByPath(Class<A> annotationType, Function<A, String> pathExtractor, Function<A, T> valueExtractor, String conflictMessageToken) {
            return this.accessors.stream().map(method -> method.getAnnotationsByType(annotationType)).flatMap(Stream::of).collect(Collectors.toMap(pathExtractor, valueExtractor, (u, v) -> {
                throw new InvalidTemplateModelException("A template model method cannot have multiple " + conflictMessageToken + " with the same path. Affected methods: " + String.valueOf(u) + ", " + String.valueOf(v) + ".");
            }));
        }

        private Predicate<String> getExcludeFieldsFilter() {
            return this.accessors.stream().map(TemplateModelUtil::getFilterFromIncludeExclude).reduce(Predicate::and).orElse(fieldName -> true);
        }

        private String getPropertyName() {
            return this.propertyName;
        }
    }
}

