/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.osgi.support;

import com.vaadin.flow.osgi.support.OsgiVaadinContributor;
import com.vaadin.flow.osgi.support.OsgiVaadinStaticResource;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

@Component(immediate=true)
public class VaadinResourceTrackerComponent {
    private HttpService httpService;
    private final Map<Long, Delegate> resourceToRegistration = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<Long, List<ServiceRegistration<? extends OsgiVaadinStaticResource>>> contributorToRegistrations = Collections.synchronizedMap(new LinkedHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, service=OsgiVaadinStaticResource.class, policy=ReferencePolicy.DYNAMIC)
    void bindResource(ServiceReference<OsgiVaadinStaticResource> resourceRef) {
        Bundle bundle = resourceRef.getBundle();
        BundleContext context = bundle.getBundleContext();
        OsgiVaadinStaticResource resource = (OsgiVaadinStaticResource)context.getService(resourceRef);
        if (resource == null) {
            return;
        }
        Long serviceId = (Long)resourceRef.getProperty("service.id");
        try {
            this.registerResource(resource, bundle, serviceId);
        }
        finally {
            context.ungetService(resourceRef);
        }
    }

    void unbindResource(ServiceReference<OsgiVaadinStaticResource> resourceRef) {
        Long serviceId = (Long)resourceRef.getProperty("service.id");
        this.unregisterResource(serviceId);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, service=OsgiVaadinContributor.class, policy=ReferencePolicy.DYNAMIC)
    void bindContributor(ServiceReference<OsgiVaadinContributor> contributorRef) {
        Bundle bundle = contributorRef.getBundle();
        BundleContext context = bundle.getBundleContext();
        OsgiVaadinContributor contributor = (OsgiVaadinContributor)context.getService(contributorRef);
        if (contributor == null) {
            return;
        }
        Long serviceId = (Long)contributorRef.getProperty("service.id");
        List<OsgiVaadinStaticResource> contributions = contributor.getContributions();
        this.contributorToRegistrations.put(serviceId, contributions.stream().map(contribution -> context.registerService(OsgiVaadinStaticResource.class, contribution, null)).collect(Collectors.toList()));
    }

    void unbindContributor(ServiceReference<OsgiVaadinContributor> contributorRef) {
        Long serviceId = (Long)contributorRef.getProperty("service.id");
        List<ServiceRegistration<? extends OsgiVaadinStaticResource>> registrations = this.contributorToRegistrations.get(serviceId);
        if (registrations != null) {
            registrations.forEach(ServiceRegistration::unregister);
        }
    }

    @Reference
    void setHttpService(HttpService service) {
        this.httpService = service;
    }

    void unsetHttpService(HttpService service) {
        this.httpService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    void activate() throws NamespaceException {
        Map<Long, Delegate> map = this.resourceToRegistration;
        synchronized (map) {
            for (Delegate registration : this.resourceToRegistration.values()) {
                registration.init(this.httpService);
                this.httpService.registerResources(registration.alias, registration.path, (HttpContext)registration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    void deactivate() {
        Map<Long, Object> map = this.resourceToRegistration;
        synchronized (map) {
            this.resourceToRegistration.values().stream().forEach(this::unregisterResource);
            this.resourceToRegistration.clear();
        }
        map = this.contributorToRegistrations;
        synchronized (map) {
            this.contributorToRegistrations.values().forEach(registrations -> registrations.forEach(ServiceRegistration::unregister));
            this.contributorToRegistrations.clear();
        }
        this.httpService = null;
    }

    private void registerResource(OsgiVaadinStaticResource resource, Bundle bundle, Long serviceId) {
        this.resourceToRegistration.put(serviceId, new Delegate(resource.getAlias(), resource.getPath(), bundle));
    }

    private void unregisterResource(Long serviceId) {
        Delegate registration = this.resourceToRegistration.remove(serviceId);
        this.unregisterResource(registration);
    }

    private void unregisterResource(Delegate registration) {
        if (registration != null && this.httpService != null) {
            this.httpService.unregister(registration.alias);
        }
    }

    private static final class Delegate
    implements HttpContext {
        private final String alias;
        private final String path;
        private final Bundle bundle;
        private volatile HttpContext context;

        Delegate(String alias, String path, Bundle bundle) {
            this.alias = alias;
            this.path = path;
            this.bundle = bundle;
        }

        void init(HttpService service) {
            this.context = service.createDefaultHttpContext();
        }

        public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
            return this.context.handleSecurity(request, response);
        }

        public URL getResource(String name) {
            return this.bundle.getResource(name);
        }

        public String getMimeType(String name) {
            return this.context.getMimeType(name);
        }
    }
}

