/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.scanner;

import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;

public class ReflectionsClassFinder
implements ClassFinder {
    private final transient ClassLoader classLoader;
    private final transient Reflections reflections;

    public ReflectionsClassFinder(URL ... urls) {
        this.classLoader = new URLClassLoader(urls, null);
        this.reflections = new Reflections((Configuration)new ConfigurationBuilder().addClassLoader(this.classLoader).setExpandSuperTypes(false).addUrls(urls));
    }

    public Set<Class<?>> getAnnotatedClasses(Class<? extends Annotation> clazz) {
        HashSet classes = new HashSet();
        classes.addAll(this.reflections.getTypesAnnotatedWith(clazz, true));
        classes.addAll(this.getAnnotatedByRepeatedAnnotation(clazz));
        return classes;
    }

    private Set<Class<?>> getAnnotatedByRepeatedAnnotation(AnnotatedElement annotationClass) {
        Repeatable repeatableAnnotation = annotationClass.getAnnotation(Repeatable.class);
        if (repeatableAnnotation != null) {
            return this.reflections.getTypesAnnotatedWith(repeatableAnnotation.value(), true);
        }
        return Collections.emptySet();
    }

    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    public <T> Class<T> loadClass(String name) throws ClassNotFoundException {
        return this.classLoader.loadClass(name);
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        return this.reflections.getSubTypesOf(type);
    }
}

