/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.migration;

import com.vaadin.flow.migration.AnnotationsRewriteStrategy;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.io.File;
import java.util.Objects;

public class MigrationConfiguration {
    private File tempMigrationFolder;
    private File[] resourceDirectories;
    private File targetDirectory;
    private boolean keepOriginalFiles;
    private boolean ignoreModulizerErrors = true;
    private AnnotationsRewriteStrategy annotationRewriteStrategy = AnnotationsRewriteStrategy.ALWAYS;
    private final File baseDirectory;
    private ClassFinder classFinder;
    private File[] javaSourceDirectories;
    private File compiledClassDirectory;

    private MigrationConfiguration(File baseDir) {
        this.baseDirectory = baseDir;
    }

    private MigrationConfiguration(MigrationConfiguration configuration) {
        this.tempMigrationFolder = configuration.getTempMigrationFolder();
        if (configuration.getResourceDirectories() != null) {
            this.resourceDirectories = (File[])configuration.getResourceDirectories().clone();
        }
        this.targetDirectory = configuration.getTargetDirectory();
        this.keepOriginalFiles = configuration.isKeepOriginalFiles();
        this.ignoreModulizerErrors = configuration.isIgnoreModulizerErrors();
        this.annotationRewriteStrategy = configuration.getAnnotationRewriteStrategy();
        this.baseDirectory = configuration.getBaseDirectory();
        this.classFinder = configuration.getClassFinder();
        if (configuration.getJavaSourceDirectories() != null) {
            this.javaSourceDirectories = (File[])configuration.getJavaSourceDirectories().clone();
        }
        this.compiledClassDirectory = configuration.getCompiledClassDirectory();
    }

    public File getTempMigrationFolder() {
        return this.tempMigrationFolder;
    }

    public File[] getResourceDirectories() {
        return this.resourceDirectories;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public boolean isKeepOriginalFiles() {
        return this.keepOriginalFiles;
    }

    public boolean isIgnoreModulizerErrors() {
        return this.ignoreModulizerErrors;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public File getCompiledClassDirectory() {
        return this.compiledClassDirectory;
    }

    public ClassFinder getClassFinder() {
        return this.classFinder;
    }

    public File[] getJavaSourceDirectories() {
        return this.javaSourceDirectories;
    }

    public AnnotationsRewriteStrategy getAnnotationRewriteStrategy() {
        return this.annotationRewriteStrategy;
    }

    static /* synthetic */ File[] access$202(MigrationConfiguration x0, File[] x1) {
        x0.resourceDirectories = x1;
        return x1;
    }

    static /* synthetic */ File[] access$702(MigrationConfiguration x0, File[] x1) {
        x0.javaSourceDirectories = x1;
        return x1;
    }

    public static class Builder {
        private final MigrationConfiguration config;

        public Builder(File baseDir) {
            this.config = new MigrationConfiguration(baseDir);
        }

        public Builder setTemporaryMigrationFolder(File file) {
            this.config.tempMigrationFolder = Objects.requireNonNull(file);
            return this;
        }

        public Builder setResourceDirectories(File[] resourceDirs) {
            MigrationConfiguration.access$202(this.config, Objects.requireNonNull(resourceDirs));
            return this;
        }

        public Builder setTargetDirectory(File targetDir) {
            this.config.targetDirectory = Objects.requireNonNull(targetDir);
            return this;
        }

        public Builder setKeepOriginalFiles(boolean keepOriginal) {
            this.config.keepOriginalFiles = keepOriginal;
            return this;
        }

        public Builder setIgnoreModulizerErrors(boolean ignoreModulizerErrors) {
            this.config.ignoreModulizerErrors = ignoreModulizerErrors;
            return this;
        }

        public Builder setClassFinder(ClassFinder finder) {
            this.config.classFinder = Objects.requireNonNull(finder);
            return this;
        }

        public Builder setJavaSourceRoots(File[] sourceRoots) {
            MigrationConfiguration.access$702(this.config, Objects.requireNonNull(sourceRoots));
            return this;
        }

        public Builder setCompiledClassDirectory(File classDirectory) {
            this.config.compiledClassDirectory = Objects.requireNonNull(classDirectory);
            return this;
        }

        public Builder setAnnotationRewriteStrategy(AnnotationsRewriteStrategy strategy) {
            this.config.annotationRewriteStrategy = Objects.requireNonNull(strategy);
            return this;
        }

        public MigrationConfiguration build() {
            return new MigrationConfiguration(this.config);
        }
    }
}

