/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.pro.licensechecker.LocalOfflineKey;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.OfflineKeyValidator;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="download-offline-license", requiresProject=false)
public class DownloadOfflineLicenseMojo
extends AbstractMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            MachineId machineId = new MachineId();
            String offlineUrl = OfflineKeyValidator.getOfflineUrl((MachineId)machineId);
            File[] locations = LocalOfflineKey.getLocations();
            String locationPath = locations.length > 0 ? locations[0].getAbsolutePath() : "~/.vaadin/offlineKeyV2";
            this.getLog().info((CharSequence)"========================================");
            this.getLog().info((CharSequence)"Vaadin Offline License Download");
            this.getLog().info((CharSequence)"========================================");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"To download an offline license for this machine, visit:");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("  " + offlineUrl));
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"The offline license will be tied to this machine's hardware ID.");
            this.getLog().info((CharSequence)"After downloading, save the license file to:");
            this.getLog().info((CharSequence)("  " + locationPath));
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"For CI/CD build servers, you can download a server license key");
            this.getLog().info((CharSequence)"that works on any machine from:");
            this.getLog().info((CharSequence)"  https://vaadin.com/myaccount/licenses");
            this.getLog().info((CharSequence)"");
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to generate offline license URL", (Throwable)e);
        }
    }
}

