/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.littemplate;

import com.vaadin.flow.internal.StringUtil;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BundleLitParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleLitParser.class);
    private static final String SOURCE = "source";
    private static final String NAME = "name";
    private static final String CHUNKS = "chunks";
    private static final String MODULES = "modules";
    private static final Pattern LIT_TEMPLATE_PATTERN = Pattern.compile("render\\(\\)[\\s]*\\{[\\s]*return[\\s]*html[\\s]*(\\`)([\\s\\S]*?)\\1;[\\s]*\\}");
    private static final Pattern HASH_PATTERN = Pattern.compile("\"hash\"\\s*:\\s*\"([^\"]+)\"\\s*,");
    private static final String TEMPLATE_TAG_NAME = "template";

    private BundleLitParser() {
    }

    public static String getHashFromStatistics(String fileContents) {
        Matcher matcher = HASH_PATTERN.matcher(fileContents);
        return matcher.find() ? matcher.group(1) : "" + fileContents.length();
    }

    public static JsonObject parseJsonStatistics(String fileContents) {
        return Json.parse((String)fileContents);
    }

    public static String getSourceFromStatistics(String fileName, JsonObject statistics) {
        return BundleLitParser.getSourceFromObject(statistics, fileName);
    }

    public static Element parseLitTemplateElement(String fileName, String source) {
        Document templateDocument = null;
        String content = StringUtil.removeComments((String)source);
        Matcher templateMatcher = LIT_TEMPLATE_PATTERN.matcher(content);
        if (templateMatcher.find() && templateMatcher.groupCount() == 2) {
            String group = templateMatcher.group(2);
            LOGGER.trace("Found regular Lit template content was {}", (Object)group);
            templateDocument = Jsoup.parse((String)group);
            LOGGER.trace("The parsed template document was {}", (Object)templateDocument);
            Element template = templateDocument.createElement(TEMPLATE_TAG_NAME);
            Element body = templateDocument.body();
            templateDocument.body().children().stream().filter(node -> !node.equals((Object)body)).forEach(arg_0 -> ((Element)template).appendChild(arg_0));
            return template;
        }
        LOGGER.warn("No lit template data found in {} sources.", (Object)fileName);
        return null;
    }

    private static String getSourceFromObject(JsonObject module, String fileName) {
        String source = null;
        if (BundleLitParser.validKey(module, MODULES, JsonType.ARRAY)) {
            source = BundleLitParser.getSourceFromArray(module.getArray(MODULES), fileName);
        }
        if (source == null && BundleLitParser.validKey(module, CHUNKS, JsonType.ARRAY)) {
            source = BundleLitParser.getSourceFromArray(module.getArray(CHUNKS), fileName);
        }
        if (source == null && BundleLitParser.validKey(module, NAME, JsonType.STRING) && BundleLitParser.validKey(module, SOURCE, JsonType.STRING)) {
            String name = module.getString(NAME);
            if (name.endsWith("es5")) {
                return source;
            }
            String alternativeFileName = fileName.replaceFirst("^(\\./)frontend/", "$1").replaceFirst("^frontend://", ".");
            if (name.contains("@vaadin/flow-frontend/") || name.contains("target/flow-frontend")) {
                alternativeFileName = alternativeFileName.replaceFirst("\\./", "");
            }
            if ((name = name.replaceFirst("\\?.+$", "")).endsWith(fileName) || name.endsWith(alternativeFileName)) {
                source = module.getString(SOURCE);
            }
        }
        return source;
    }

    private static String getSourceFromArray(JsonArray objects, String fileName) {
        String source = null;
        for (int i = 0; source == null && i < objects.length(); ++i) {
            if (!objects.get(i).getType().equals((Object)JsonType.OBJECT)) continue;
            source = BundleLitParser.getSourceFromObject((JsonObject)objects.get(i), fileName);
        }
        return source;
    }

    private static boolean validKey(JsonObject o, String k, JsonType t) {
        boolean validKey = o != null && o.hasKey(k) && o.get(k).getType().equals((Object)t);
        return validKey && (!t.equals((Object)JsonType.STRING) || !o.getString(k).isEmpty());
    }
}

