/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.gradle;

import com.vaadin.flow.plugin.base.BuildFrontendUtil;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.plugin.base.PluginAdapterBuild;
import com.vaadin.flow.server.frontend.BundleValidationUtil;
import com.vaadin.flow.server.frontend.TaskCleanFrontendFiles;
import com.vaadin.gradle.GradlePluginAdapter;
import com.vaadin.gradle.PluginEffectiveConfiguration;
import com.vaadin.pro.licensechecker.LicenseChecker;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/vaadin/gradle/VaadinBuildFrontendTask;", "Lorg/gradle/api/DefaultTask;", "()V", "config", "Lcom/vaadin/gradle/PluginEffectiveConfiguration;", "cleanFrontendFiles", "", "vaadinBuildFrontend", "", "flow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nVaadinBuildFrontendTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VaadinBuildFrontendTask.kt\ncom/vaadin/gradle/VaadinBuildFrontendTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public class VaadinBuildFrontendTask
extends DefaultTask {
    @NotNull
    private final PluginEffectiveConfiguration config;

    public VaadinBuildFrontendTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.config = PluginEffectiveConfiguration.Companion.get$flow_gradle_plugin(project);
        this.setGroup("Vaadin");
        this.setDescription("Builds the frontend bundle with webpack");
        Object[] objectArray = new Object[]{"vaadinPrepareFrontend"};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"classes"};
        this.dependsOn(objectArray);
        this.getProject().getTasks().withType(Jar.class, arg_0 -> VaadinBuildFrontendTask._init_$lambda$0(1.INSTANCE, arg_0));
    }

    @TaskAction
    public final void vaadinBuildFrontend() {
        this.getLogger().info("Running the vaadinBuildFrontend task with effective configuration " + this.config);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        GradlePluginAdapter adapter = new GradlePluginAdapter(project, this.config, false);
        File tokenFile = BuildFrontendUtil.getTokenFile((PluginAdapterBase)((PluginAdapterBase)adapter));
        if (!tokenFile.exists()) {
            boolean bl = false;
            String string = "token file " + tokenFile + " doesn't exist!";
            throw new IllegalStateException(string.toString());
        }
        TaskCleanFrontendFiles cleanTask = new TaskCleanFrontendFiles((File)this.config.getNpmFolder().get());
        BuildFrontendUtil.runNodeUpdater((PluginAdapterBuild)adapter);
        if (adapter.generateBundle() && BundleValidationUtil.needsBundleBuild((File)adapter.servletResourceOutputDirectory())) {
            BuildFrontendUtil.runFrontendBuild((PluginAdapterBase)((PluginAdapterBase)adapter));
            if (this.cleanFrontendFiles()) {
                cleanTask.execute();
            }
        }
        LicenseChecker.setStrictOffline((boolean)true);
        BuildFrontendUtil.validateLicenses((PluginAdapterBase)((PluginAdapterBase)adapter));
        BuildFrontendUtil.updateBuildFile((PluginAdapterBuild)adapter);
    }

    protected boolean cleanFrontendFiles() {
        return true;
    }

    private static final void _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

