/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataViewUtils;
import com.vaadin.flow.data.provider.ItemCountChangeEvent;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.QueryTrace;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.ExecutionContext;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.Range;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

public class DataCommunicator<T>
implements Serializable {
    public static final int DEFAULT_PAGE_INCREASE_COUNT = 4;
    private static final int DEFAULT_PAGE_SIZE = 50;
    private final DataGenerator<T> dataGenerator;
    private final ArrayUpdater arrayUpdater;
    private final SerializableConsumer<JsonArray> dataUpdater;
    private final StateNode stateNode;
    private final HashMap<Integer, Set<String>> passivatedByUpdate = new HashMap();
    private final HashSet<Integer> confirmedUpdates = new HashSet();
    private final ArrayList<QuerySortOrder> backEndSorting = new ArrayList();
    private DataKeyMapper<T> keyMapper = new KeyMapper<T>();
    private Range requestedRange = Range.between((int)0, (int)0);
    private int activeStart = 0;
    private List<String> activeKeyOrder = Collections.emptyList();
    private int assumedSize;
    private int lastSent = -1;
    private boolean resendEntireRange = true;
    private boolean assumeEmptyClient = true;
    private int nextUpdateId = 0;
    private DataProvider<T, ?> dataProvider = new EmptyDataProvider();
    private Filter<?> filter;
    private SerializableComparator<T> inMemorySorting;
    private Registration dataProviderUpdateRegistration;
    private HashSet<T> updatedData = new HashSet();
    private SerializableConsumer<ExecutionContext> flushRequest;
    private SerializableConsumer<ExecutionContext> flushUpdatedDataRequest;
    private CallbackDataProvider.CountCallback<T, ?> countCallback;
    private int itemCountEstimate = -1;
    private int itemCountEstimateIncrease = -1;
    private boolean definedSize = true;
    private boolean skipCountIncreaseUntilReset;
    private boolean sizeReset;
    private int pageSize = 50;
    private boolean pagingEnabled = true;
    private boolean fetchEnabled;

    public DataCommunicator(DataGenerator<T> dataGenerator, ArrayUpdater arrayUpdater, SerializableConsumer<JsonArray> dataUpdater, StateNode stateNode) {
        this(dataGenerator, arrayUpdater, dataUpdater, stateNode, true);
    }

    public DataCommunicator(DataGenerator<T> dataGenerator, ArrayUpdater arrayUpdater, SerializableConsumer<JsonArray> dataUpdater, StateNode stateNode, boolean fetchEnabled) {
        this.dataGenerator = dataGenerator;
        this.arrayUpdater = arrayUpdater;
        this.dataUpdater = dataUpdater;
        this.stateNode = stateNode;
        this.fetchEnabled = fetchEnabled;
        stateNode.addAttachListener(this::handleAttach);
        stateNode.addDetachListener(this::handleDetach);
        this.requestFlush();
    }

    public void setRequestedRange(int start, int length) {
        this.requestedRange = Range.withLength((int)start, (int)length);
        this.requestFlush();
    }

    public void reset() {
        this.skipCountIncreaseUntilReset = false;
        this.sizeReset = true;
        this.resendEntireRange = true;
        this.dataGenerator.destroyAllData();
        this.updatedData.clear();
        this.requestFlush();
    }

    public void refresh(T data) {
        Objects.requireNonNull(data, "DataCommunicator can not refresh null object");
        this.getKeyMapper().refresh(data);
        this.dataGenerator.refreshData(data);
        this.updatedData.add(data);
        this.requestFlushUpdatedData();
    }

    public void confirmUpdate(int updateId) {
        this.confirmedUpdates.add(updateId);
        this.unregisterPassivatedKeys();
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.dataProvider;
    }

    public <F> SerializableConsumer<Filter<F>> setDataProvider(DataProvider<T, F> dataProvider, F initialFilter, boolean notifiesOnChange) {
        Objects.requireNonNull(dataProvider, "data provider cannot be null");
        this.removeFilteringAndSorting();
        this.filter = initialFilter != null ? new Filter<F>(initialFilter, notifiesOnChange) : null;
        this.countCallback = null;
        this.definedSize = true;
        this.sizeReset = true;
        this.handleDetach();
        this.reset();
        this.getKeyMapper().removeAll();
        this.dataProvider = dataProvider;
        this.getKeyMapper().setIdentifierGetter(dataProvider::getId);
        this.handleAttach();
        return (SerializableConsumer & Serializable)filter -> {
            if (this.dataProvider != dataProvider) {
                throw new IllegalStateException("Filter slot is no longer valid after data provider has been changed");
            }
            if (!Objects.equals(this.filter, filter)) {
                this.filter = filter;
                this.reset();
            }
        };
    }

    public <F> SerializableConsumer<F> setDataProvider(DataProvider<T, F> dataProvider, F initialFilter) {
        SerializableConsumer filterConsumer = this.setDataProvider(dataProvider, initialFilter, true);
        return (SerializableConsumer & Serializable)newFilter -> filterConsumer.accept(new Filter<Object>(newFilter));
    }

    public int getItemCount() {
        if (this.isDefinedSize() && (this.resendEntireRange || this.assumeEmptyClient || this.sizeReset)) {
            return this.getDataProviderSize();
        }
        if (!this.isDefinedSize() && this.sizeReset) {
            return 0;
        }
        return this.assumedSize;
    }

    public boolean isItemActive(T item) {
        return this.getKeyMapper().has(item);
    }

    public T getItem(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index must be non-negative");
        }
        int activeDataEnd = this.activeStart + this.activeKeyOrder.size() - 1;
        if (index >= this.activeStart && index <= activeDataEnd) {
            return this.getKeyMapper().get(this.activeKeyOrder.get(index - this.activeStart));
        }
        int itemCount = this.getItemCount();
        if (this.isDefinedSize()) {
            if (itemCount == 0) {
                throw new IndexOutOfBoundsException(String.format("Requested index %d on empty data.", index));
            }
            if (index >= itemCount) {
                throw new IndexOutOfBoundsException(String.format("Given index %d is outside of the accepted range '0 - %d'", index, itemCount - 1));
            }
        }
        return this.getDataProvider().fetch(this.buildQuery(index, 1)).findFirst().orElse(null);
    }

    public Query buildQuery(int offset, int limit) {
        return new Query<T, Object>(offset, limit, this.getBackEndSorting(), this.getInMemorySorting(), this.getFilter());
    }

    public void setPageSize(int pageSize) {
        if (pageSize < 1) {
            throw new IllegalArgumentException(String.format("Page size cannot be less than 1, got %d", pageSize));
        }
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setCountCallback(CallbackDataProvider.CountCallback<T, ?> countCallback) {
        if (countCallback == null) {
            throw new IllegalArgumentException("Provided size callback cannot be null - for switching between defined and undefined size use setDefinedSize(boolean) method instead.");
        }
        this.countCallback = countCallback;
        this.definedSize = true;
        this.skipCountIncreaseUntilReset = false;
        this.sizeReset = true;
        this.requestFlush();
    }

    public void setItemCountEstimate(int itemCountEstimate) {
        if (itemCountEstimate < 1) {
            throw new IllegalArgumentException("Given item count estimate cannot be less than 1.");
        }
        this.itemCountEstimate = itemCountEstimate;
        this.countCallback = null;
        this.definedSize = false;
        if (!this.skipCountIncreaseUntilReset && this.requestedRange.getEnd() < itemCountEstimate) {
            this.sizeReset = true;
            this.requestFlush();
        }
    }

    public int getItemCountEstimate() {
        if (this.itemCountEstimate < 1) {
            return this.pageSize * 4;
        }
        return this.itemCountEstimate;
    }

    public void setItemCountEstimateIncrease(int itemCountEstimateIncrease) {
        if (itemCountEstimateIncrease < 1) {
            throw new IllegalArgumentException("itemCountEstimateIncrease cannot be less than 1");
        }
        this.itemCountEstimateIncrease = itemCountEstimateIncrease;
        this.countCallback = null;
        this.definedSize = false;
    }

    public int getItemCountEstimateIncrease() {
        if (this.itemCountEstimateIncrease == -1) {
            return this.pageSize * 4;
        }
        assert (this.itemCountEstimate > 0) : "0 is not an increase";
        return this.itemCountEstimateIncrease;
    }

    public void setDefinedSize(boolean definedSize) {
        if (this.definedSize != definedSize) {
            this.definedSize = definedSize;
            this.countCallback = null;
            this.skipCountIncreaseUntilReset = false;
            if (definedSize) {
                this.requestFlush();
            } else if (this.requestedRange.contains(this.assumedSize - 1)) {
                this.requestFlush();
            }
        }
    }

    public boolean isDefinedSize() {
        return this.definedSize;
    }

    public DataKeyMapper<T> getKeyMapper() {
        return this.keyMapper;
    }

    protected void setKeyMapper(DataKeyMapper<T> keyMapper) {
        this.keyMapper = keyMapper;
    }

    public void setInMemorySorting(SerializableComparator<T> comparator) {
        this.inMemorySorting = comparator;
        this.reset();
    }

    public SerializableComparator<T> getInMemorySorting() {
        return this.inMemorySorting;
    }

    public void setBackEndSorting(List<QuerySortOrder> sortOrder) {
        this.backEndSorting.clear();
        this.backEndSorting.addAll(sortOrder);
        this.reset();
    }

    public List<QuerySortOrder> getBackEndSorting() {
        return Collections.unmodifiableList(this.backEndSorting);
    }

    public boolean isPagingEnabled() {
        return this.pagingEnabled;
    }

    public void setPagingEnabled(boolean pagingEnabled) {
        this.pagingEnabled = pagingEnabled;
    }

    public boolean isFetchEnabled() {
        return this.fetchEnabled;
    }

    public void setFetchEnabled(boolean fetchEnabled) {
        this.fetchEnabled = fetchEnabled;
    }

    public int getDataProviderSize() {
        assert (this.definedSize) : "This method should never be called when using undefined size";
        if (this.countCallback != null) {
            return this.countCallback.count(new Query(this.getFilter()));
        }
        return this.getDataProvider().size(new Query(this.getFilter()));
    }

    private void updateUndefinedSize() {
        assert (!this.definedSize) : "This method should never be called when using defined size";
        if (this.resendEntireRange || this.sizeReset) {
            this.assumedSize = this.getItemCountEstimate();
        }
        while (this.requestedRange.getEnd() + this.pageSize > this.assumedSize) {
            this.assumedSize += this.getItemCountEstimateIncrease();
        }
    }

    protected Object getFilter() {
        return this.filter != null ? this.filter.getFilterObject() : null;
    }

    protected Stream<T> fetchFromProvider(int offset, int limit) {
        Stream<Object> stream;
        if (this.pagingEnabled) {
            int pages = (limit - 1) / this.pageSize + 1;
            if (limit > this.pageSize) {
                Stream.Builder streamBuilder = Stream.builder();
                AtomicInteger fetchedPerPage = new AtomicInteger(0);
                Consumer<Object> addItemAndCheckConsumer = item -> {
                    streamBuilder.add(item);
                    fetchedPerPage.getAndIncrement();
                };
                int page = 0;
                do {
                    int newOffset = offset + page * this.pageSize;
                    this.doFetchFromDataProvider(newOffset, this.pageSize).forEach(addItemAndCheckConsumer);
                } while (++page < pages && fetchedPerPage.getAndSet(0) == this.pageSize);
                stream = streamBuilder.build();
            } else {
                stream = this.doFetchFromDataProvider(offset, this.pageSize);
            }
            limit = pages * this.pageSize;
        } else {
            stream = this.doFetchFromDataProvider(offset, limit);
        }
        if (stream.isParallel()) {
            LoggerFactory.getLogger(DataCommunicator.class).debug("Data provider {} has returned parallel stream on 'fetch' call", this.getDataProvider().getClass());
            stream = stream.collect(Collectors.toList()).stream();
            assert (!stream.isParallel());
        }
        SizeVerifier verifier = new SizeVerifier(limit);
        return stream.peek(verifier);
    }

    private Stream<T> doFetchFromDataProvider(int offset, int limitedTo) {
        QueryTrace<T, Object> query = new QueryTrace<T, Object>(offset, limitedTo, (List<QuerySortOrder>)this.backEndSorting, this.inMemorySorting, this.getFilter());
        Stream<T> stream = this.getDataProvider().fetch(query);
        this.verifyQueryContract(query);
        return stream;
    }

    private void verifyQueryContract(QueryTrace query) {
        if (!query.isLimitCalled()) {
            throw new IllegalStateException(this.getInvalidContractMessage("getLimit() or getPageSize()"));
        }
        if (!query.isOffsetCalled()) {
            throw new IllegalStateException(this.getInvalidContractMessage("getOffset() or getPage()"));
        }
    }

    private String getInvalidContractMessage(String method) {
        return String.format("The data provider hasn't ever called %s method on the provided query. It means that the the data provider breaks the contract and the returned stream contains unexpected data.", method);
    }

    private void handleAttach() {
        if (this.dataProviderUpdateRegistration != null) {
            this.dataProviderUpdateRegistration.remove();
        }
        this.dataProviderUpdateRegistration = this.getDataProvider().addDataProviderListener(event -> {
            if (event instanceof DataChangeEvent.DataRefreshEvent) {
                this.handleDataRefreshEvent((DataChangeEvent.DataRefreshEvent)event);
            } else {
                this.reset();
            }
        });
        this.requestFlush();
    }

    protected void handleDataRefreshEvent(DataChangeEvent.DataRefreshEvent<T> event) {
        this.refresh(event.getItem());
    }

    private void handleDetach() {
        this.dataGenerator.destroyAllData();
        if (this.dataProviderUpdateRegistration != null) {
            this.dataProviderUpdateRegistration.remove();
            this.dataProviderUpdateRegistration = null;
        }
    }

    private void requestFlush() {
        this.requestFlush(false);
    }

    private void requestFlush(boolean forced) {
        if ((this.flushRequest == null || forced) && this.fetchEnabled) {
            this.flushRequest = (SerializableConsumer & Serializable)context -> {
                if (!context.isClientSideInitialized()) {
                    this.reset();
                    this.arrayUpdater.initialize();
                }
                this.flush();
                this.flushRequest = null;
            };
            this.stateNode.runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(this.stateNode, this.flushRequest));
        }
    }

    private void requestFlushUpdatedData() {
        if (this.flushUpdatedDataRequest == null) {
            this.flushUpdatedDataRequest = (SerializableConsumer & Serializable)context -> {
                this.flushUpdatedData();
                this.flushUpdatedDataRequest = null;
            };
            this.stateNode.runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(this.stateNode, this.flushUpdatedDataRequest));
        }
    }

    private void flush() {
        HashSet<String> oldActive = new HashSet<String>(this.activeKeyOrder);
        Range previousActive = Range.withLength((int)this.activeStart, (int)this.activeKeyOrder.size());
        if (this.definedSize && (this.resendEntireRange || this.sizeReset)) {
            this.assumedSize = this.getDataProviderSize();
        } else if (!(this.definedSize || this.skipCountIncreaseUntilReset && !this.sizeReset)) {
            this.updateUndefinedSize();
        }
        Range effectiveRequested = this.requestedRange.restrictTo(Range.withLength((int)0, (int)this.assumedSize));
        this.resendEntireRange |= !previousActive.intersects(effectiveRequested) && (!previousActive.isEmpty() || !effectiveRequested.isEmpty());
        Activation activation = this.collectKeysToFlush(previousActive, effectiveRequested);
        if (activation.isSizeRecheckNeeded()) {
            if (this.definedSize) {
                this.assumedSize = this.getDataProviderSize();
            } else {
                this.assumedSize = this.requestedRange.getStart() + activation.getActiveKeys().size();
                this.skipCountIncreaseUntilReset = true;
                if (this.assumedSize != 0 && activation.getActiveKeys().isEmpty()) {
                    int delta = this.requestedRange.length();
                    this.requestedRange = this.requestedRange.offsetBy(-delta).restrictTo(Range.withLength((int)0, (int)this.assumedSize));
                    this.requestFlush(true);
                    return;
                }
            }
            effectiveRequested = this.requestedRange.restrictTo(Range.withLength((int)0, (int)this.assumedSize));
        }
        this.activeKeyOrder = activation.getActiveKeys();
        this.activeStart = effectiveRequested.getStart();
        ArrayUpdater.Update update = this.arrayUpdater.startUpdate(this.assumedSize);
        boolean updated = this.collectChangesToSend(previousActive, effectiveRequested, update);
        this.resendEntireRange = false;
        this.assumeEmptyClient = false;
        this.sizeReset = false;
        this.passivateInactiveKeys(oldActive, update, updated);
        this.unregisterPassivatedKeys();
        this.fireItemCountEvent(this.assumedSize);
    }

    private void fireItemCountEvent(int itemCount) {
        boolean notify;
        boolean bl = notify = this.filter == null || this.filter.isNotifyOnChange();
        if (this.lastSent != itemCount && notify) {
            Optional component = Element.get((StateNode)this.stateNode).getComponent();
            component.ifPresent(value -> ComponentUtil.fireEvent((Component)value, new ItemCountChangeEvent<Component>((Component)value, itemCount, !this.isDefinedSize() && !this.skipCountIncreaseUntilReset)));
            this.lastSent = itemCount;
        }
    }

    private void flushUpdatedData() {
        if (this.updatedData.isEmpty()) {
            return;
        }
        this.dataUpdater.accept(this.updatedData.stream().map(this::generateJson).collect(JsonUtils.asArray()));
        this.updatedData.clear();
    }

    private void unregisterPassivatedKeys() {
        if (!this.confirmedUpdates.isEmpty()) {
            this.confirmedUpdates.forEach(this::doUnregister);
            this.confirmedUpdates.clear();
        }
    }

    private void doUnregister(Integer updateId) {
        Set<String> passivated = this.passivatedByUpdate.remove(updateId);
        if (passivated != null) {
            passivated.forEach(key -> {
                T item = this.keyMapper.get((String)key);
                if (item != null) {
                    this.dataGenerator.destroyData(item);
                    this.keyMapper.remove(item);
                }
            });
        }
    }

    private void passivateInactiveKeys(Set<String> oldActive, ArrayUpdater.Update update, boolean updated) {
        if (updated) {
            int updateId = this.nextUpdateId++;
            update.commit(updateId);
            oldActive.removeAll(this.activeKeyOrder);
            if (!oldActive.isEmpty()) {
                this.passivatedByUpdate.put(updateId, oldActive);
            }
        }
    }

    private boolean collectChangesToSend(Range previousActive, Range effectiveRequested, ArrayUpdater.Update update) {
        boolean updated = false;
        if (this.assumeEmptyClient || this.resendEntireRange) {
            if (!this.assumeEmptyClient) {
                update.clear(previousActive.getStart(), previousActive.length());
            }
            update.set(this.activeStart, this.getJsonItems(effectiveRequested));
            updated = true;
        } else if (!previousActive.equals((Object)effectiveRequested)) {
            DataCommunicator.withMissing(previousActive, effectiveRequested, range -> update.clear(range.getStart(), range.length()));
            DataCommunicator.withMissing(effectiveRequested, previousActive, range -> update.set(range.getStart(), this.getJsonItems((Range)range)));
            updated = true;
        }
        return updated;
    }

    private Activation collectKeysToFlush(Range previousActive, Range effectiveRequested) {
        if (this.resendEntireRange) {
            return this.activate(effectiveRequested);
        }
        ArrayList<String> newActiveKeyOrder = new ArrayList<String>();
        boolean sizeRecheckNeeded = false;
        Range[] partitionWith = effectiveRequested.partitionWith(previousActive);
        Activation activation = this.activate(partitionWith[0]);
        newActiveKeyOrder.addAll(activation.getActiveKeys());
        sizeRecheckNeeded |= activation.isSizeRecheckNeeded();
        Range overlap = partitionWith[1].offsetBy(-this.activeStart);
        if (overlap.getStart() < 0) {
            return Activation.empty();
        }
        newActiveKeyOrder.addAll(this.activeKeyOrder.subList(overlap.getStart(), overlap.getEnd()));
        activation = this.activate(partitionWith[2]);
        newActiveKeyOrder.addAll(activation.getActiveKeys());
        return new Activation(newActiveKeyOrder, sizeRecheckNeeded |= activation.isSizeRecheckNeeded());
    }

    private List<JsonValue> getJsonItems(Range range) {
        return range.stream().mapToObj(index -> this.activeKeyOrder.get(index - this.activeStart)).map(this.keyMapper::get).map(this::generateJson).collect(Collectors.toList());
    }

    private static void withMissing(Range expected, Range actual, Consumer<Range> action) {
        Range[] partition = expected.partitionWith(actual);
        DataCommunicator.applyIfNotEmpty(partition[0], action);
        DataCommunicator.applyIfNotEmpty(partition[2], action);
    }

    private static void applyIfNotEmpty(Range range, Consumer<Range> action) {
        if (!range.isEmpty()) {
            action.accept(range);
        }
    }

    private Activation activate(Range range) {
        if (range.isEmpty()) {
            return Activation.empty();
        }
        ArrayList<String> activeKeys = new ArrayList<String>(range.length());
        this.fetchFromProvider(range.getStart(), range.length()).forEach(bean -> {
            boolean mapperHasKey = this.keyMapper.has(bean);
            String key = this.keyMapper.key(bean);
            if (mapperHasKey) {
                this.keyMapper.refresh(bean);
                this.passivatedByUpdate.values().stream().forEach(set -> set.remove(key));
            }
            activeKeys.add(key);
        });
        boolean needsSizeRecheck = activeKeys.size() < range.length();
        return new Activation(activeKeys, needsSizeRecheck);
    }

    private JsonValue generateJson(T item) {
        JsonObject json = Json.createObject();
        json.put("key", this.getKeyMapper().key(item));
        this.dataGenerator.generateData(item, json);
        return json;
    }

    private void removeFilteringAndSorting() {
        Element.get((StateNode)this.stateNode).getComponent().ifPresent(DataViewUtils::removeComponentFilterAndSortComparator);
    }

    private static class Activation
    implements Serializable {
        private final List<String> activeKeys;
        private final boolean sizeRecheckNeeded;

        public Activation(List<String> activeKeys, boolean sizeRecheckNeeded) {
            this.activeKeys = activeKeys;
            this.sizeRecheckNeeded = sizeRecheckNeeded;
        }

        public List<String> getActiveKeys() {
            return this.activeKeys;
        }

        public boolean isSizeRecheckNeeded() {
            return this.sizeRecheckNeeded;
        }

        public static Activation empty() {
            return new Activation(Collections.emptyList(), false);
        }
    }

    private static class SizeVerifier<T>
    implements Consumer<T>,
    Serializable {
        private int size;
        private final int limit;

        private SizeVerifier(int limit) {
            this.limit = limit;
        }

        @Override
        public void accept(T t) {
            ++this.size;
            if (this.size > this.limit) {
                throw new IllegalStateException(String.format("The number of items returned by the data provider exceeds the limit specified by the query (%d).", this.limit));
            }
        }
    }

    public static final class Filter<F>
    implements Serializable {
        private F filterObject;
        private boolean notifyOnChange;

        public Filter(F filterObject) {
            this.filterObject = filterObject;
            this.notifyOnChange = true;
        }

        public Filter(F filterObject, boolean notifyOnChange) {
            this.filterObject = filterObject;
            this.notifyOnChange = notifyOnChange;
        }

        public F getFilterObject() {
            return this.filterObject;
        }

        public boolean isNotifyOnChange() {
            return this.notifyOnChange;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Filter filter1 = (Filter)o;
            return this.notifyOnChange == filter1.notifyOnChange && Objects.equals(this.filterObject, filter1.filterObject);
        }

        public int hashCode() {
            return Objects.hash(this.filterObject, this.notifyOnChange);
        }
    }

    public static final class EmptyDataProvider<T1>
    extends ListDataProvider<T1> {
        public EmptyDataProvider() {
            super(new ArrayList(0));
        }
    }
}

