/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.BinderValidationErrorHandler;
import com.vaadin.flow.data.binder.ErrorLevel;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.dom.ThemeList;
import java.util.Optional;
import java.util.stream.Stream;

public class DefaultBinderValidationErrorHandler
implements BinderValidationErrorHandler {
    @Override
    public void handleError(HasValue<?, ?> field, ValidationResult result) {
        if (field instanceof HasValidation) {
            HasValidation fieldWithValidation = (HasValidation)field;
            fieldWithValidation.setInvalid(true);
            fieldWithValidation.setErrorMessage(result.getErrorMessage());
        }
        this.setErrorTheme(field, result);
    }

    @Override
    public void clearError(HasValue<?, ?> field) {
        if (field instanceof HasValidation) {
            HasValidation fieldWithValidation = (HasValidation)field;
            fieldWithValidation.setInvalid(false);
        }
        this.clearErrorTheme(field);
    }

    protected String getErrorThemeName(ErrorLevel errorLevel) {
        return errorLevel.name().toLowerCase();
    }

    protected Optional<ThemeList> getThemes(HasValue<?, ?> field) {
        if (field instanceof HasTheme) {
            return Optional.of(((HasTheme)field).getThemeNames());
        }
        if (field instanceof HasElement) {
            return Optional.of(((HasElement)field).getElement().getThemeList());
        }
        return Optional.empty();
    }

    protected void clearErrorTheme(HasValue<?, ?> field) {
        this.getThemes(field).ifPresent(themes -> Stream.of(ErrorLevel.values()).map(this::getErrorThemeName).forEach(arg_0 -> themes.remove(arg_0)));
    }

    protected void setErrorTheme(HasValue<?, ?> field, ValidationResult result) {
        result.getErrorLevel().map(this::getErrorThemeName).ifPresent(errorTheme -> this.getThemes(field).ifPresent(themes -> themes.add(errorTheme)));
    }
}

