/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.HasDataGenerators;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class CompositeDataGenerator<T>
implements DataGenerator<T>,
HasDataGenerators<T> {
    private final Set<DataGenerator<T>> dataGenerators = new HashSet<DataGenerator<T>>();

    @Override
    public void generateData(T item, JsonObject jsonObject) {
        this.dataGenerators.forEach(generator -> generator.generateData(item, jsonObject));
    }

    @Override
    public void destroyData(T item) {
        this.dataGenerators.forEach(generator -> generator.destroyData(item));
    }

    @Override
    public void destroyAllData() {
        this.dataGenerators.forEach(DataGenerator::destroyAllData);
    }

    @Override
    public void refreshData(T item) {
        this.dataGenerators.forEach(generator -> generator.refreshData(item));
    }

    @Override
    public Registration addDataGenerator(DataGenerator<T> generator) {
        assert (generator != null) : "generator should not be null";
        this.dataGenerators.add(generator);
        return (Registration & Serializable)() -> this.removeDataGenerator(generator);
    }

    private void removeDataGenerator(DataGenerator<T> generator) {
        generator.destroyAllData();
        this.dataGenerators.remove(generator);
    }
}

