/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.ConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.Query;

public abstract class ConfigurableFilterDataProviderWrapper<T, Q, C, F>
extends DataProviderWrapper<T, Q, F>
implements ConfigurableFilterDataProvider<T, Q, C> {
    private C configuredFilter;

    public ConfigurableFilterDataProviderWrapper(DataProvider<T, F> dataProvider) {
        super(dataProvider);
    }

    @Override
    protected F getFilter(Query<T, Q> query) {
        Q queryFilter = query.getFilter().orElse(null);
        if (this.configuredFilter == null && queryFilter == null) {
            return null;
        }
        return this.combineFilters(queryFilter, this.configuredFilter);
    }

    protected abstract F combineFilters(Q var1, C var2);

    @Override
    public void setFilter(C filter) {
        this.configuredFilter = filter;
        this.refreshAll();
    }

    @Override
    public String toString() {
        return "ConfigurableFilterDataProviderWrapper(" + String.valueOf(this.dataProvider) + ")";
    }
}

