/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.validator;

import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.validator.AbstractValidator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexpValidator
extends AbstractValidator<String> {
    private Pattern pattern;
    private boolean complete;
    private transient Matcher matcher = null;

    public RegexpValidator(String errorMessage, String regexp) {
        this(errorMessage, regexp, true);
    }

    public RegexpValidator(String errorMessage, String regexp, boolean complete) {
        super(errorMessage);
        this.pattern = Pattern.compile(regexp);
        this.complete = complete;
    }

    @Override
    public ValidationResult apply(String value, ValueContext context) {
        return this.toResult(value, this.isValid(value));
    }

    public String toString() {
        return "RegexpValidator[" + String.valueOf(this.pattern) + "]";
    }

    protected boolean isValid(String value) {
        if (value == null) {
            return true;
        }
        if (this.complete) {
            return this.getMatcher(value).matches();
        }
        return this.getMatcher(value).find();
    }

    private Matcher getMatcher(String value) {
        if (this.matcher == null) {
            this.matcher = this.pattern.matcher(value);
        } else {
            this.matcher.reset(value);
        }
        return this.matcher;
    }
}

