/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Objects;

public class ReadOnlyHasValue<V>
implements HasValue<HasValue.ValueChangeEvent<V>, V>,
Serializable {
    private V value;
    private final SerializableConsumer<V> valueProcessor;
    private final V emptyValue;
    private LinkedHashSet<HasValue.ValueChangeListener<? super HasValue.ValueChangeEvent<V>>> listenerList;

    public ReadOnlyHasValue(SerializableConsumer<V> valueProcessor, V emptyValue) {
        this.valueProcessor = valueProcessor;
        this.emptyValue = emptyValue;
    }

    public ReadOnlyHasValue(SerializableConsumer<V> valueProcessor) {
        this(valueProcessor, null);
    }

    public void setValue(V value) {
        V oldValue = this.value;
        this.value = value;
        this.valueProcessor.accept(value);
        if (this.listenerList != null && !Objects.equals(oldValue, value)) {
            for (HasValue.ValueChangeListener valueChangeListener : this.listenerList) {
                valueChangeListener.valueChanged(new ReadOnlyValueChangeEvent<V>(this, value, oldValue));
            }
        }
    }

    public V getValue() {
        return this.value;
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super HasValue.ValueChangeEvent<V>> listener) {
        Objects.requireNonNull(listener, "Listener must not be null.");
        if (this.listenerList == null) {
            this.listenerList = new LinkedHashSet();
        }
        return Registration.addAndRemove(this.listenerList, listener);
    }

    public boolean isRequiredIndicatorVisible() {
        return false;
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        if (requiredIndicatorVisible) {
            throw new IllegalArgumentException("Not Writable");
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (!readOnly) {
            throw new IllegalArgumentException("Not Writable");
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    public V getEmptyValue() {
        return this.emptyValue;
    }

    private static class ReadOnlyValueChangeEvent<V>
    implements HasValue.ValueChangeEvent<V> {
        private HasValue<?, V> hasValue;
        private V value;
        private V oldValue;

        public ReadOnlyValueChangeEvent(HasValue<?, V> hasValue, V value, V oldValue) {
            this.hasValue = hasValue;
            this.value = value;
            this.oldValue = oldValue;
        }

        public HasValue<?, V> getHasValue() {
            return this.hasValue;
        }

        public boolean isFromClient() {
            return false;
        }

        public V getOldValue() {
            return this.oldValue;
        }

        public V getValue() {
            return this.value;
        }
    }
}

