/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.validator;

import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.validator.AbstractValidator;
import java.util.Comparator;
import java.util.Objects;

public class RangeValidator<T>
extends AbstractValidator<T> {
    private T minValue = null;
    private T maxValue = null;
    private boolean minValueIncluded = true;
    private boolean maxValueIncluded = true;
    private final Comparator<? super T> comparator;

    public RangeValidator(String errorMessage, Comparator<? super T> comparator, T minValue, T maxValue) {
        super(errorMessage);
        Objects.requireNonNull(comparator, "comparator cannot be null");
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.minValueIncluded = minValue != null;
        this.maxValueIncluded = maxValue != null;
        this.comparator = comparator;
    }

    public static <C extends Comparable<? super C>> RangeValidator<C> of(String errorMessage, C minValue, C maxValue) {
        return new RangeValidator(errorMessage, Comparator.nullsFirst(Comparator.naturalOrder()), minValue, maxValue);
    }

    @Override
    public ValidationResult apply(T value, ValueContext context) {
        return this.toResult(value, this.isValid(value));
    }

    public boolean isMinValueIncluded() {
        return this.minValueIncluded;
    }

    public void setMinValueIncluded(boolean minValueIncluded) {
        this.minValueIncluded = minValueIncluded;
    }

    public boolean isMaxValueIncluded() {
        return this.maxValueIncluded;
    }

    public void setMaxValueIncluded(boolean maxValueIncluded) {
        this.maxValueIncluded = maxValueIncluded;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public void setMinValue(T minValue) {
        this.minValue = minValue;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(T maxValue) {
        this.maxValue = maxValue;
    }

    public String toString() {
        T min = this.getMinValue();
        T max = this.getMaxValue();
        char openBracket = this.isMinValueIncluded() ? (char)'[' : '(';
        char closeBracket = this.isMaxValueIncluded() ? (char)']' : ')';
        Object minValue = min != null ? min : "-\u221e";
        Object maxValue = max != null ? max : "\u221e";
        return String.format("%s %c%s, %s%c", this.getClass().getSimpleName(), Character.valueOf(openBracket), minValue, maxValue, Character.valueOf(closeBracket));
    }

    protected boolean isValid(T value) {
        int result;
        if (value == null) {
            return true;
        }
        if (this.getMinValue() != null) {
            result = this.comparator.compare(value, this.getMinValue());
            if (result < 0) {
                return false;
            }
            if (result == 0 && !this.isMinValueIncluded()) {
                return false;
            }
        }
        if (this.getMaxValue() != null) {
            result = this.comparator.compare(value, this.getMaxValue());
            if (result > 0) {
                return false;
            }
            if (result == 0 && !this.isMaxValueIncluded()) {
                return false;
            }
        }
        return true;
    }
}

