/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.hierarchy.AbstractHierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class TreeDataProvider<T>
extends AbstractHierarchicalDataProvider<T, SerializablePredicate<T>>
implements InMemoryDataProvider<T> {
    private final TreeData<T> treeData;
    private SerializablePredicate<T> filter = null;
    private SerializableComparator<T> sortOrder = null;

    public TreeDataProvider(TreeData<T> treeData) {
        Objects.requireNonNull(treeData, "treeData cannot be null");
        this.treeData = treeData;
    }

    public TreeData<T> getTreeData() {
        return this.treeData;
    }

    @Override
    public boolean hasChildren(T item) {
        if (!this.treeData.contains(item)) {
            return false;
        }
        return !this.treeData.getChildren(item).isEmpty();
    }

    @Override
    public int getChildCount(HierarchicalQuery<T, SerializablePredicate<T>> query) {
        if (query.getFilter().isPresent()) {
            Stream childStream = this.getFilteredStream(this.treeData.getChildren(query.getParent()).stream(), query.getFilter());
            return (int)childStream.skip(query.getOffset()).limit(query.getLimit()).count();
        }
        if (query.getParent() != null) {
            return this.treeData.getChildren(query.getParent()).size();
        }
        return this.treeData.getRootItems().size();
    }

    @Override
    public Stream<T> fetchChildren(HierarchicalQuery<T, SerializablePredicate<T>> query) {
        if (!this.treeData.contains(query.getParent())) {
            throw new IllegalArgumentException("The queried item " + query.getParent() + " could not be found in the backing TreeData. Did you forget to refresh this data provider after item removal?");
        }
        Stream childStream = this.getFilteredStream(this.treeData.getChildren(query.getParent()).stream(), query.getFilter());
        Optional<Comparator> comparing = Stream.of(query.getInMemorySorting(), this.sortOrder).filter(Objects::nonNull).reduce((c1, c2) -> c1.thenComparing(c2));
        if (comparing.isPresent()) {
            childStream = childStream.sorted(comparing.get());
        }
        return childStream.skip(query.getOffset()).limit(query.getLimit());
    }

    @Override
    public SerializablePredicate<T> getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(SerializablePredicate<T> filter) {
        this.filter = filter;
        this.refreshAll();
    }

    @Override
    public SerializableComparator<T> getSortComparator() {
        return this.sortOrder;
    }

    @Override
    public void setSortComparator(SerializableComparator<T> comparator) {
        this.sortOrder = comparator;
        this.refreshAll();
    }

    @Override
    public <C> DataProvider<T, C> withConvertedFilter(final SerializableFunction<C, SerializablePredicate<T>> filterConverter) {
        Objects.requireNonNull(filterConverter, "Filter converter can't be null");
        return new DataProviderWrapper<T, C, SerializablePredicate<T>>(this){

            @Override
            protected SerializablePredicate<T> getFilter(Query<T, C> query) {
                return query.getFilter().map(filterConverter).orElse(null);
            }

            @Override
            public int size(Query<T, C> t) {
                if (t instanceof HierarchicalQuery) {
                    return this.dataProvider.size(new HierarchicalQuery(t.getOffset(), t.getLimit(), t.getSortOrders(), t.getInMemorySorting(), this.getFilter((Query<T, C>)t), ((HierarchicalQuery)t).getParent()));
                }
                throw new IllegalArgumentException("Hierarchical data provider doesn't support non-hierarchical queries");
            }

            @Override
            public Stream<T> fetch(Query<T, C> t) {
                if (t instanceof HierarchicalQuery) {
                    return this.dataProvider.fetch(new HierarchicalQuery(t.getOffset(), t.getLimit(), t.getSortOrders(), t.getInMemorySorting(), this.getFilter((Query<T, C>)t), ((HierarchicalQuery)t).getParent()));
                }
                throw new IllegalArgumentException("Hierarchical data provider doesn't support non-hierarchical queries");
            }
        };
    }

    private Stream<T> getFilteredStream(Stream<T> stream, Optional<SerializablePredicate<T>> queryFilter) {
        if (this.filter != null) {
            stream = stream.filter((Predicate<T>)this.filter);
        }
        return queryFilter.map(stream::filter).orElse(stream);
    }
}

