/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.shared.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA
//  cldrVersion=25
//  date=$Date: 2014-03-14 18:20:13 +0100 (Fri, 14 Mar 2014) $
//  number=$Revision: 9967 $
//  type=sl

/**
 * Implementation of DateTimeFormatInfo for the "sl" locale.
 */
public class DateTimeFormatInfoImpl_sl extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "dop.",
        "pop."
    };
  }

  @Override
  public String dateFormatFull() {
    return "EEEE, dd. MMMM y";
  }

  @Override
  public String dateFormatLong() {
    return "dd. MMMM y";
  }

  @Override
  public String dateFormatMedium() {
    return "d. MMM y";
  }

  @Override
  public String dateFormatShort() {
    return "d. MM. yy";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "pred našim štetjem",
        "naše štetje"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "pr. n. št.",
        "po Kr."
    };
  }

  @Override
  public String formatHour12Minute() {
    return "h.mm a";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "h.mm.ss a";
  }

  @Override
  public String formatHour24Minute() {
    return "HH.mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "HH.mm.ss";
  }

  @Override
  public String formatMinuteSecond() {
    return "mm.ss";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d. MMM";
  }

  @Override
  public String formatMonthFullDay() {
    return "d. MMMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, d. MMMM";
  }

  @Override
  public String formatMonthNumDay() {
    return "d. M.";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "d. MMM y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "d. MMMM y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d. M. y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, d. MMM y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "januar",
        "februar",
        "marec",
        "april",
        "maj",
        "junij",
        "julij",
        "avgust",
        "september",
        "oktober",
        "november",
        "december"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "j",
        "f",
        "m",
        "a",
        "m",
        "j",
        "j",
        "a",
        "s",
        "o",
        "n",
        "d"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "jan.",
        "feb.",
        "mar.",
        "apr.",
        "maj",
        "jun.",
        "jul.",
        "avg.",
        "sep.",
        "okt.",
        "nov.",
        "dec."
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return new String[] {
        "jan",
        "feb",
        "mar",
        "apr",
        "maj",
        "jun",
        "jul",
        "avg",
        "sep",
        "okt",
        "nov",
        "dec"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "1. četrtletje",
        "2. četrtletje",
        "3. četrtletje",
        "4. četrtletje"
    };
  }

  @Override
  public String timeFormatFull() {
    return "HH.mm.ss zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "HH.mm.ss z";
  }

  @Override
  public String timeFormatMedium() {
    return "HH.mm.ss";
  }

  @Override
  public String timeFormatShort() {
    return "HH.mm";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "nedelja",
        "ponedeljek",
        "torek",
        "sreda",
        "četrtek",
        "petek",
        "sobota"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "n",
        "p",
        "t",
        "s",
        "č",
        "p",
        "s"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "ned.",
        "pon.",
        "tor.",
        "sre.",
        "čet.",
        "pet.",
        "sob."
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return new String[] {
        "ned",
        "pon",
        "tor",
        "sre",
        "čet",
        "pet",
        "sob"
    };
  }
}
