/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptor;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.CompletionAware;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.util.ChunkConcatReaderPool;
import org.atmosphere.util.IOUtils;

public class SimpleRestInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleRestInterceptor.class);
    public static final String PROTOCOL_DETACHED_KEY = "atmosphere.simple-rest.protocol.detached";
    public static final String X_ATMOSPHERE_SIMPLE_REST_PROTOCOL_DETACHED = "X-Atmosphere-SimpleRestProtocolDetached";
    protected static final String REQUEST_DISPATCHED = "request.dispatched";
    protected static final String REQUEST_ID = "request.id";
    private static final byte[] RESPONSE_TEMPLATE_HEAD = "{\"id\": \"".getBytes();
    private static final byte[] RESPONSE_TEMPLATE_BELLY = "\", \"data\": ".getBytes();
    private static final byte[] RESPONSE_TEMPLATE_BELLY_CONTINUE = "\", \"continue\":true, \"data\": ".getBytes();
    private static final byte[] RESPONSE_TEMPLATE_BELLY_DETACHED = "\", \"detached\": true".getBytes();
    private static final byte[] RESPONSE_TEMPLATE_BELLY_CONTINUE_DETACHED = "\", \"continue\":true, \"detached\": true".getBytes();
    private static final byte[] RESPONSE_TEMPLATE_TAIL = "}".getBytes();
    private static final byte[] RESPONSE_TEMPLATE_NEWLINE = "\n".getBytes();
    private static final String HEARTBEAT_BROADCASTER_NAME = "/simple-rest.heartbeat";
    private static final String HEARTBEAT_SCHEDULED = "heatbeat.scheduled";
    private static final String HEARTBEAT_TEMPLATE = "{\"heartbeat\": \"%s\", \"time\": %d}";
    private static final long DEFAULT_HEARTBEAT_INTERVAL = 60L;
    private Map<String, AtmosphereResponse> suspendedResponses = new HashMap<String, AtmosphereResponse>();
    private ChunkConcatReaderPool readerPool = new ChunkConcatReaderPool();
    private boolean detached;
    private Broadcaster heartbeat;
    private boolean heartbeatScheduled;
    private final AsyncIOInterceptor interceptor = new Interceptor();

    @Override
    public void configure(AtmosphereConfig config) {
        super.configure(config);
        this.detached = Boolean.parseBoolean(config.getInitParameter(PROTOCOL_DETACHED_KEY));
        this.heartbeat = config.getBroadcasterFactory().lookup(DefaultBroadcaster.class, this.getHeartbeatBroadcasterName());
        if (this.heartbeat == null) {
            this.heartbeat = config.getBroadcasterFactory().get(DefaultBroadcaster.class, this.getHeartbeatBroadcasterName());
        }
    }

    @Override
    public Action inspect(final AtmosphereResource r) {
        if (AtmosphereResource.TRANSPORT.WEBSOCKET != r.transport() && AtmosphereResource.TRANSPORT.SSE != r.transport() && AtmosphereResource.TRANSPORT.POLLING != r.transport()) {
            LOG.debug("Skipping for non websocket request");
            return Action.CONTINUE;
        }
        if (AtmosphereResource.TRANSPORT.POLLING == r.transport()) {
            String saruuid = (String)r.getRequest().getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid");
            final AtmosphereResponse suspendedResponse = this.suspendedResponses.get(saruuid);
            LOG.debug("Attaching a proxy writer to suspended response");
            r.getResponse().asyncIOWriter(new AtmosphereInterceptorWriter(){

                @Override
                public AsyncIOWriter write(AtmosphereResponse r, String data) throws IOException {
                    suspendedResponse.write(data);
                    suspendedResponse.flushBuffer();
                    return this;
                }

                @Override
                public AsyncIOWriter write(AtmosphereResponse r, byte[] data) throws IOException {
                    suspendedResponse.write(data);
                    suspendedResponse.flushBuffer();
                    return this;
                }

                @Override
                public AsyncIOWriter write(AtmosphereResponse r, byte[] data, int offset, int length) throws IOException {
                    suspendedResponse.write(data, offset, length);
                    suspendedResponse.flushBuffer();
                    return this;
                }

                @Override
                public void close(AtmosphereResponse response) throws IOException {
                }
            });
            r.getResponse().destroyable(false);
            return Action.CONTINUE;
        }
        r.addEventListener(new AtmosphereResourceEventListenerAdapter(){

            @Override
            public void onSuspend(AtmosphereResourceEvent event) {
                String srid = (String)event.getResource().getRequest().getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid");
                LOG.debug("Registrering suspended resource: {}", (Object)srid);
                SimpleRestInterceptor.this.suspendedResponses.put(srid, event.getResource().getResponse());
                AsyncIOWriter writer = event.getResource().getResponse().getAsyncIOWriter();
                if (writer == null) {
                    writer = new AtmosphereInterceptorWriter();
                    r.getResponse().asyncIOWriter(writer);
                }
                if (writer instanceof AtmosphereInterceptorWriter) {
                    ((AtmosphereInterceptorWriter)writer).interceptor(SimpleRestInterceptor.this.interceptor);
                }
            }

            @Override
            public void onDisconnect(AtmosphereResourceEvent event) {
                super.onDisconnect(event);
                String srid = (String)event.getResource().getRequest().getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid");
                LOG.debug("Unregistrering suspended resource: {}", (Object)srid);
                SimpleRestInterceptor.this.suspendedResponses.remove(srid);
            }
        });
        AtmosphereRequest request = r.getRequest();
        if (request.getAttribute(REQUEST_DISPATCHED) == null) {
            try {
                String body = IOUtils.readEntirelyAsString(r).toString();
                LOG.debug("Request message: '{}'", (Object)body);
                if (body.length() == 0) {
                    if ((AtmosphereResource.TRANSPORT.WEBSOCKET == r.transport() || AtmosphereResource.TRANSPORT.SSE == r.transport()) && request.getAttribute(HEARTBEAT_SCHEDULED) == null) {
                        r.suspend();
                        this.scheduleHeartbeat(r);
                        request.setAttribute(HEARTBEAT_SCHEDULED, "true");
                        return Action.SUSPEND;
                    }
                    return Action.CANCELLED;
                }
                AtmosphereRequest ar = this.createAtmosphereRequest(request, body);
                if (ar == null) {
                    return Action.CANCELLED;
                }
                AtmosphereResponse response = r.getResponse();
                ar.localAttributes().put(REQUEST_DISPATCHED, "true");
                request.removeAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE);
                response.request(ar);
                this.attachWriter(r);
                Action action = r.getAtmosphereConfig().framework().doCometSupport(ar, response);
                if (action.type() == Action.TYPE.SUSPEND) {
                    ar.destroyable(false);
                    response.destroyable(false);
                }
                return Action.CANCELLED;
            }
            catch (IOException | ServletException e) {
                LOG.error("Failed to process", e);
            }
        }
        return Action.CONTINUE;
    }

    protected String getHeartbeatBroadcasterName() {
        return HEARTBEAT_BROADCASTER_NAME;
    }

    protected String getHeartbeatTemplate() {
        return HEARTBEAT_TEMPLATE;
    }

    protected Object[] getHeartbeatTemplateArguments() {
        return new Object[]{UUID.randomUUID().toString(), System.currentTimeMillis()};
    }

    protected AtmosphereRequest createAtmosphereRequest(AtmosphereRequest request, String body) throws IOException {
        Reader data;
        int qpos;
        JSONEnvelopeReader jer = new JSONEnvelopeReader(new StringReader(body));
        String id = jer.getHeader("id");
        if (id != null) {
            request.localAttributes().put(REQUEST_ID, id);
        }
        boolean skip = false;
        boolean continued = Boolean.valueOf(jer.getHeader("continue"));
        Reader reader = this.readerPool.getReader(id, false);
        if (reader != null) {
            skip = true;
        } else if (continued) {
            reader = this.readerPool.getReader(id, true);
        }
        if (skip) {
            Reader data2 = jer.getReader();
            if (data2 != null) {
                this.readerPool.addChunk(id, data2, continued);
            }
            return null;
        }
        String method = jer.getHeader("method");
        String path = jer.getHeader("path");
        String type = jer.getHeader("type");
        String accept = jer.getHeader("accept");
        AtmosphereRequestImpl.Builder b = new AtmosphereRequestImpl.Builder();
        b.method(method != null ? method : "GET").pathInfo(path != null ? path : "/");
        if (accept != null || type != null) {
            TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            if (accept != null) {
                headers.put("Accept", accept);
            }
            if (type != null) {
                b.contentType(type);
            }
            b.headers(headers);
        }
        if ((qpos = path.indexOf(63)) > 0) {
            b.queryString(path.substring(qpos + 1));
            path = path.substring(0, qpos);
        }
        if ((data = jer.getReader()) != null) {
            if (reader != null) {
                b.reader(reader);
                this.readerPool.addChunk(id, data, true);
            } else {
                b.reader(data);
            }
        }
        String requestURL = request.getRequestURL() + path.substring(request.getRequestURI().length());
        b.requestURI(path).requestURL(requestURL).request(request);
        return b.build();
    }

    protected byte[] createResponse(AtmosphereResponse response, byte[] payload) {
        AtmosphereRequest request;
        String id;
        if (LOG.isDebugEnabled()) {
            LOG.debug("createResponse for payload {}", (Object)new String(payload));
        }
        if ((id = (String)(request = response.request()).getAttribute(REQUEST_ID)) == null) {
            return payload;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (id != null) {
            try {
                baos.write(RESPONSE_TEMPLATE_HEAD);
                baos.write(id.getBytes());
                if (this.isDetached(request)) {
                    if (SimpleRestInterceptor.isLastResponse(request, response)) {
                        baos.write(RESPONSE_TEMPLATE_BELLY_DETACHED);
                    } else {
                        baos.write(RESPONSE_TEMPLATE_BELLY_CONTINUE_DETACHED);
                    }
                    baos.write(RESPONSE_TEMPLATE_TAIL);
                    baos.write(RESPONSE_TEMPLATE_NEWLINE);
                    baos.write(payload);
                } else {
                    boolean isobj = SimpleRestInterceptor.isJSONObject(payload);
                    if (SimpleRestInterceptor.isLastResponse(request, response)) {
                        baos.write(RESPONSE_TEMPLATE_BELLY);
                    } else {
                        baos.write(RESPONSE_TEMPLATE_BELLY_CONTINUE);
                    }
                    if (!isobj) {
                        baos.write(SimpleRestInterceptor.quote(payload));
                    } else {
                        baos.write(payload);
                    }
                    baos.write(RESPONSE_TEMPLATE_TAIL);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return baos.toByteArray();
    }

    private void scheduleHeartbeat(AtmosphereResource r) {
        this.heartbeat.addAtmosphereResource(r);
        if (!this.heartbeatScheduled) {
            this.heartbeat.scheduleFixedBroadcast(String.format(this.getHeartbeatTemplate(), this.getHeartbeatTemplateArguments()), 60L, 60L, TimeUnit.SECONDS);
            this.heartbeatScheduled = true;
        }
    }

    protected static boolean isLastResponse(AtmosphereRequest request, AtmosphereResponse response) {
        return response instanceof CompletionAware && ((CompletionAware)((Object)response)).completed() || Boolean.TRUE != request.getAttribute("org.atmosphere.cpr.ResponseCompletionAware");
    }

    protected boolean isDetached(AtmosphereRequest request) {
        String prop = request.getHeader(X_ATMOSPHERE_SIMPLE_REST_PROTOCOL_DETACHED);
        return this.detached && prop == null || Boolean.valueOf(prop) != false;
    }

    private void attachWriter(AtmosphereResource r) {
        AtmosphereResponse res = r.getResponse();
        AsyncIOWriter writer = res.getAsyncIOWriter();
        if (writer instanceof AtmosphereInterceptorWriter) {
            ((AtmosphereInterceptorWriter)writer).interceptor(this.interceptor, 0);
        }
    }

    protected static boolean isJSONObject(byte[] b) {
        return b.length > 0 && (b[0] == 91 || b[0] == 123);
    }

    protected static byte[] quote(byte[] b) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(34);
        for (byte c : b) {
            if (c == 34) {
                baos.write(92);
            }
            baos.write(c);
        }
        baos.write(34);
        return baos.toByteArray();
    }

    static class JSONEnvelopeReader {
        private Reader reader;
        private Map<String, String> headers;
        private boolean datap;
        private boolean detachedp;
        private int peek = -1;

        public JSONEnvelopeReader(Reader reader) throws IOException {
            this.reader = reader;
            this.headers = new HashMap<String, String>();
            this.prepare();
        }

        public String getHeader(String name) {
            return this.headers.get(name);
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public Reader getReader() {
            if (!this.datap && !this.detachedp) {
                return null;
            }
            return new Reader(){
                private int b;

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    int n = JSONEnvelopeReader.this.reader.read(cbuf, off, len);
                    if (n > 0) {
                        boolean escaping = false;
                        char quot = '\u0000';
                        for (int i = off; i < n; ++i) {
                            char c = cbuf[i];
                            if (c == '{' && !escaping) {
                                ++this.b;
                                continue;
                            }
                            if (c == '}' && !escaping) {
                                --this.b;
                                if (this.b >= 0) continue;
                                --n;
                                continue;
                            }
                            if (!(c != '\"' && c != '\'' || escaping)) {
                                if (c == quot) {
                                    quot = '\u0000';
                                    continue;
                                }
                                quot = c;
                                continue;
                            }
                            if (c == '\\' && quot != '\u0000' && !escaping) {
                                escaping = true;
                                continue;
                            }
                            if (!escaping) continue;
                            escaping = false;
                        }
                    }
                    return n;
                }

                @Override
                public void close() throws IOException {
                    JSONEnvelopeReader.this.reader.close();
                }

                @Override
                public boolean ready() throws IOException {
                    return JSONEnvelopeReader.this.reader.ready();
                }
            };
        }

        private void prepare() throws IOException {
            block9: {
                int c = this.next(true);
                if (c == 123) {
                    do {
                        String name = this.nextName();
                        c = this.next(true);
                        if (c == 58) {
                            if ("data".equals(name)) {
                                this.datap = true;
                                break block9;
                            }
                            if ("detached".equals(name)) {
                                if (!Boolean.valueOf(this.nextValue()).booleanValue()) continue;
                                this.detachedp = true;
                                continue;
                            }
                            this.headers.put(name, this.nextValue());
                            continue;
                        }
                        throw new IOException("invalid value: missing name-separator ':'");
                    } while ((c = this.next(true)) == 44);
                    if (c == 125 && this.detachedp) {
                        while (c != -1 && (c = this.next(false)) != 10) {
                        }
                    } else {
                        this.unread(c);
                    }
                } else {
                    throw new IOException("invalid object: missing being-object '{'");
                }
            }
        }

        private String nextName() throws IOException {
            int c = this.next(true);
            if (c == 34 || c == 39) {
                return this.nextQuoted(c);
            }
            throw new IOException("invalid name: missing quote '\"'");
        }

        private String nextValue() throws IOException {
            int c = this.next(true);
            if (c == 34 || c == 39) {
                return this.nextQuoted(c);
            }
            if (c == 116 || c == 102 || 48 <= c && c <= 57) {
                this.unread(c);
                return this.nextNonQuoted();
            }
            throw new IOException("invalid value: unquoted non literals");
        }

        private String nextQuoted(int quot) throws IOException {
            int c;
            StringBuilder sb = new StringBuilder();
            boolean escaping = false;
            while ((c = this.next(false)) != -1) {
                if (c == 92 && !escaping) {
                    escaping = true;
                    continue;
                }
                if (c == quot && !escaping) break;
                sb.append((char)c);
                if (!escaping) continue;
                escaping = false;
            }
            if (c != -1) {
                return sb.toString();
            }
            throw new IOException("invalid quoted string: missing quotation");
        }

        private String nextNonQuoted() throws IOException {
            int c;
            StringBuilder sb = new StringBuilder();
            while ((c = this.next(false)) != -1) {
                if (c == 125 || c == 44 || this.isWS(c)) {
                    this.unread(c);
                    break;
                }
                sb.append((char)c);
            }
            if (c != -1) {
                return sb.toString();
            }
            throw new IOException("invalid value: non-terminated");
        }

        private int next(boolean skipws) throws IOException {
            int c;
            if (this.peek != -1) {
                c = this.peek;
                this.peek = -1;
            } else {
                while ((c = this.reader.read()) != -1 && skipws && this.isWS(c)) {
                }
            }
            return c;
        }

        private void unread(int c) {
            this.peek = c;
        }

        private boolean isWS(int c) {
            return c == 32 || c == 9 || c == 10 || c == 13;
        }
    }

    private final class Interceptor
    extends AsyncIOInterceptorAdapter {
        private Interceptor() {
        }

        @Override
        public byte[] transformPayload(AtmosphereResponse response, byte[] responseDraft, byte[] data) throws IOException {
            return SimpleRestInterceptor.this.createResponse(response, responseDraft);
        }
    }
}

