/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.Jetty9WebSocketHandler;
import org.atmosphere.container.Servlet30CometSupport;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.Utils;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.ServletWebSocketRequest;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

abstract class AbstractJetty9AsyncSupportWithWebSocket
extends Servlet30CometSupport {
    private static final Logger staticLogger = LoggerFactory.getLogger(AbstractJetty9AsyncSupportWithWebSocket.class);
    private final Logger logger;

    static WebSocketPolicy GetPolicy(AtmosphereConfig config) {
        String max;
        String bs = config.getInitParameter("org.atmosphere.websocket.bufferSize");
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        if (bs != null) {
            policy.setInputBufferSize(Integer.parseInt(bs));
        }
        if ((max = config.getInitParameter("org.atmosphere.websocket.maxIdleTime")) != null) {
            policy.setIdleTimeout((long)Integer.parseInt(max));
        }
        try {
            String serverInfo = config.getServletConfig().getServletContext().getServerInfo();
            boolean isJetty91Plus = false;
            if (serverInfo != null) {
                int version = Integer.valueOf(serverInfo.split("/")[1].substring(0, 3).replace(".", ""));
                boolean bl = isJetty91Plus = version > 90;
            }
            if ((max = config.getInitParameter("org.atmosphere.websocket.maxTextMessageSize")) != null) {
                Method m = isJetty91Plus ? policy.getClass().getMethod("setMaxTextMessageSize", Integer.TYPE) : policy.getClass().getMethod("setMaxMessageSize", Long.TYPE);
                m.invoke((Object)policy, Integer.parseInt(max));
            }
            if ((max = config.getInitParameter("org.atmosphere.websocket.maxBinaryMessageSize")) != null) {
                Method m = isJetty91Plus ? policy.getClass().getMethod("setMaxBinaryMessageSize", Integer.TYPE) : policy.getClass().getMethod("setMaxMessageSize", Long.TYPE);
                m.invoke((Object)policy, Integer.parseInt(max));
            }
        }
        catch (Exception ex) {
            staticLogger.warn("", (Throwable)ex);
        }
        return policy;
    }

    AbstractJetty9AsyncSupportWithWebSocket(AtmosphereConfig config, Logger logger) {
        super(config);
        this.logger = logger;
    }

    WebSocketCreator buildCreator(final HttpServletRequest request, final HttpServletResponse response, final WebSocketProcessor webSocketProcessor) {
        return new WebSocketCreator(){

            public Object createWebSocket(UpgradeRequest upgradeRequest, UpgradeResponse upgradeResponse) {
                ServletWebSocketRequest r = (ServletWebSocketRequest)ServletWebSocketRequest.class.cast(upgradeRequest);
                r.getExtensions().clear();
                if (!webSocketProcessor.handshake(request)) {
                    try {
                        response.sendError(403, "WebSocket requests rejected.");
                    }
                    catch (IOException e) {
                        AbstractJetty9AsyncSupportWithWebSocket.this.logger.trace("", (Throwable)e);
                    }
                    return null;
                }
                return new Jetty9WebSocketHandler(request, AbstractJetty9AsyncSupportWithWebSocket.this.config.framework(), webSocketProcessor);
            }

            public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
                req.getExtensions().clear();
                if (!webSocketProcessor.handshake(request)) {
                    try {
                        response.sendError(403, "WebSocket requests rejected.");
                    }
                    catch (IOException e) {
                        AbstractJetty9AsyncSupportWithWebSocket.this.logger.trace("", (Throwable)e);
                    }
                    return null;
                }
                return new Jetty9WebSocketHandler(request, AbstractJetty9AsyncSupportWithWebSocket.this.config.framework(), webSocketProcessor);
            }
        };
    }

    abstract WebSocketServerFactory getWebSocketFactory();

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Boolean b = (Boolean)req.getAttribute(WebSocket.WEBSOCKET_INITIATED);
        if (b == null) {
            b = Boolean.FALSE;
        }
        if (!Utils.webSocketEnabled(req) && req.getAttribute(WebSocket.WEBSOCKET_ACCEPT_DONE) == null) {
            if (req.resource() != null && req.resource().transport() == AtmosphereResource.TRANSPORT.WEBSOCKET) {
                WebSocket.notSupported(req, res);
                return Action.CANCELLED;
            }
            return super.service(req, res);
        }
        if (this.getWebSocketFactory() != null && !b.booleanValue()) {
            req.setAttribute(WebSocket.WEBSOCKET_INITIATED, true);
            this.getWebSocketFactory().acceptWebSocket((HttpServletRequest)req, (HttpServletResponse)res);
            req.setAttribute(WebSocket.WEBSOCKET_ACCEPT_DONE, true);
            return new Action();
        }
        Action action = this.suspended(req, res);
        if (action.type() != Action.TYPE.SUSPEND && action.type() == Action.TYPE.RESUME) {
            req.setAttribute(WebSocket.WEBSOCKET_RESUME, true);
        }
        return action == null ? super.service(req, res) : action;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }
}

