/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket.protocol;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.websocket.WebSocket;

public class ProtocolUtil {
    private static final Logger logger = LoggerFactory.getLogger(ProtocolUtil.class);

    protected static AtmosphereRequest.Builder constructRequest(WebSocket webSocket, String pathInfo, String requestURI, String methodType, String contentType, boolean destroyable) {
        AtmosphereResource resource = webSocket.resource();
        AtmosphereRequest request = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(resource)).getRequest(false);
        Map<String, Object> m = ProtocolUtil.attributes(webSocket, request);
        AtmosphereRequest.Builder b = new AtmosphereRequest.Builder().request((HttpServletRequest)request).method(methodType).contentType(contentType == null ? request.getContentType() : contentType).attributes(m).pathInfo(pathInfo).contextPath(request.getContextPath()).servletPath(request.getServletPath()).requestURI(requestURI).requestURL(request.requestURL()).destroyable(destroyable).headers(request.headersMap()).session(resource.session());
        return b;
    }

    private static Map<String, Object> attributes(WebSocket webSocket, AtmosphereRequest request) {
        ConcurrentHashMap<String, Object> m = new ConcurrentHashMap<String, Object>();
        m.putAll(webSocket.attributes());
        return m;
    }
}

