/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class JDK7ForkJoinPool
extends AbstractExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(JDK7ForkJoinPool.class);
    private final AbstractExecutorService forkJoinPool;
    private final boolean shared;

    public JDK7ForkJoinPool(boolean shared, final String threadName) {
        this.shared = shared;
        this.forkJoinPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), new ForkJoinPool.ForkJoinWorkerThreadFactory(){

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                return new JDK7ForkJoinWorkerThread(pool, JDK7ForkJoinPool.this.shared, threadName);
            }
        }, null, false);
    }

    public AbstractExecutorService pool() {
        return this.forkJoinPool;
    }

    @Override
    public void shutdown() {
        this.forkJoinPool.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.forkJoinPool.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.forkJoinPool.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.forkJoinPool.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.forkJoinPool.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.forkJoinPool.execute(command);
    }

    private static final class JDK7ForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        private final AtomicInteger count = new AtomicInteger();

        protected JDK7ForkJoinWorkerThread(ForkJoinPool pool, boolean shared, String threadName) {
            super(pool);
            this.setName((shared ? "Atmosphere-Shared-" : threadName) + this.count.getAndIncrement());
        }
    }
}

