/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.inject;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.atmosphere.inject.Injectable;

public class InjectableObjectFactory
implements AtmosphereObjectFactory<Injectable<?>> {
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereFramework.class);
    private static final ServiceLoader<Injectable> injectableServiceLoader = ServiceLoader.load(Injectable.class);
    private final LinkedList<Injectable<?>> injectables = new LinkedList();
    private AtmosphereConfig config;

    @Override
    public void configure(AtmosphereConfig config) {
        this.config = config;
        for (Injectable i : injectableServiceLoader) {
            try {
                logger.debug("Adding class {} as injectable", i.getClass());
                this.injectables.addFirst(i);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    @Override
    public <T, U extends T> U newClassInstance(Class<T> classType, Class<U> defaultType) throws InstantiationException, IllegalAccessException {
        U instance = defaultType.newInstance();
        this.injectAtmosphereInternalObject(instance, defaultType, this.config.framework());
        this.postConstructExecution(instance, defaultType);
        return instance;
    }

    public <U> void postConstructExecution(U instance, Class<U> defaultType) throws IllegalAccessException {
        HashSet<Method> methods = new HashSet<Method>();
        methods.addAll(Arrays.asList(defaultType.getDeclaredMethods()));
        methods.addAll(Arrays.asList(defaultType.getMethods()));
        this.injectMethods(methods, instance);
    }

    private <U> void injectMethods(Set<Method> methods, U instance) throws IllegalAccessException {
        for (Method m : methods) {
            if (!m.isAnnotationPresent(PostConstruct.class)) continue;
            try {
                m.setAccessible(true);
                m.invoke(instance, new Object[0]);
                break;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public <U> void injectAtmosphereInternalObject(U instance, Class<U> defaultType, AtmosphereFramework framework) throws IllegalAccessException {
        HashSet<Field> fields = new HashSet<Field>();
        fields.addAll(Arrays.asList(defaultType.getDeclaredFields()));
        fields.addAll(Arrays.asList(defaultType.getFields()));
        this.injectFields(fields, instance, framework);
    }

    private <U> void injectFields(Set<Field> fields, U instance, AtmosphereFramework framework) throws IllegalAccessException {
        block0: for (Field field : fields) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            for (Injectable injectable : this.injectables) {
                if (!injectable.supportedType(field.getType())) continue;
                field.setAccessible(true);
                field.set(instance, injectable.injectable(framework.getAtmosphereConfig()));
                continue block0;
            }
        }
    }

    @Override
    public AtmosphereObjectFactory allowInjectionOf(Injectable<?> injectable) {
        this.injectables.add(injectable);
        return this;
    }

    public String toString() {
        return InjectableObjectFactory.class.getName();
    }

    public <U> U getInjectable(Class<U> u) {
        for (Injectable injectable : this.injectables) {
            if (!injectable.supportedType(u)) continue;
            return (U)injectable.injectable(this.config);
        }
        return null;
    }
}

