/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.FrameworkConfig;

public class SessionSupport
implements HttpSessionListener {
    private final Logger logger = LoggerFactory.getLogger(SessionSupport.class);
    public static boolean initializationHint = false;

    public SessionSupport() {
        initializationHint = true;
    }

    public void sessionCreated(HttpSessionEvent se) {
        this.logger.trace("Session created");
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        this.logger.trace("Session destroyed");
        try {
            HttpSession s = se.getSession();
            BroadcasterFactory f = (BroadcasterFactory)s.getAttribute(FrameworkConfig.BROADCASTER_FACTORY);
            if (f != null) {
                s.setAttribute(FrameworkConfig.BROADCASTER_FACTORY, null);
                for (Broadcaster b : f.lookupAll()) {
                    for (AtmosphereResource r : b.getAtmosphereResources()) {
                        if (r.session() == null || !r.session().getId().equals(s.getId())) continue;
                        ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).session(null);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn("", t);
        }
    }
}

