/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.Serializer;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;

public class DefaultAtmosphereResourceFactory
implements AtmosphereResourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAtmosphereResourceFactory.class);
    private static final Broadcaster noOps = (Broadcaster)Proxy.newProxyInstance(Broadcaster.class.getClassLoader(), new Class[]{Broadcaster.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("isDestroyed")) {
                return false;
            }
            return null;
        }
    });
    private static final AtmosphereHandler noOpsHandler = (AtmosphereHandler)Proxy.newProxyInstance(AtmosphereHandler.class.getClassLoader(), new Class[]{AtmosphereHandler.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return null;
        }
    });
    private static final AtmosphereHandler voidAtmosphereHandler = new AbstractReflectorAtmosphereHandler(){

        @Override
        public void onRequest(AtmosphereResource resource) throws IOException {
        }

        @Override
        public void destroy() {
        }
    };
    private BroadcasterFactory broadcasterFactory;
    private final ConcurrentHashMap<String, AtmosphereResource> resources = new ConcurrentHashMap();

    @Override
    public void configure(AtmosphereConfig config) {
        this.broadcasterFactory = config.getBroadcasterFactory();
    }

    @Override
    public AtmosphereResource create(AtmosphereConfig config, AtmosphereRequest request, AtmosphereResponse response, AsyncSupport<?> a) {
        AtmosphereResource r = null;
        try {
            r = config.framework().newClassInstance(AtmosphereResource.class, AtmosphereResourceImpl.class);
            r.initialize(config, null, request, response, a, voidAtmosphereHandler);
            this.setDefaultSerializer(config, r);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return r;
    }

    @Override
    public AtmosphereResource create(AtmosphereConfig config, Broadcaster broadcaster, AtmosphereRequest request, AtmosphereResponse response, AsyncSupport<?> a, AtmosphereHandler handler) {
        return this.create(config, broadcaster, request, response, a, handler, AtmosphereResource.TRANSPORT.UNDEFINED);
    }

    @Override
    public AtmosphereResource create(AtmosphereConfig config, Broadcaster broadcaster, AtmosphereRequest request, AtmosphereResponse response, AsyncSupport<?> a, AtmosphereHandler handler, AtmosphereResource.TRANSPORT t) {
        AtmosphereResource r = null;
        try {
            r = config.framework().newClassInstance(AtmosphereResource.class, AtmosphereResourceImpl.class);
            if (request.getHeader("X-Atmosphere-Transport") == null) {
                request.header("X-Atmosphere-Transport", t.name());
            }
            r.initialize(config, broadcaster, request, response, a, handler);
            this.setDefaultSerializer(config, r);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return r;
    }

    @Override
    public AtmosphereResource create(AtmosphereConfig config, Broadcaster broadcaster, AtmosphereResponse response, AsyncSupport<?> a, AtmosphereHandler handler) {
        return this.create(config, broadcaster, response.request(), response, a, handler);
    }

    @Override
    public AtmosphereResource create(AtmosphereConfig config, Broadcaster broadcaster, AtmosphereResponse response, AsyncSupport<?> a, AtmosphereHandler handler, AtmosphereResource.TRANSPORT t) {
        return this.create(config, broadcaster, response.request(), response, a, handler, t);
    }

    @Override
    public AtmosphereResource create(AtmosphereConfig config, AtmosphereResponse response, AsyncSupport<?> a) {
        AtmosphereResource r = null;
        try {
            r = config.framework().newClassInstance(AtmosphereResource.class, AtmosphereResourceImpl.class);
            r.initialize(config, null, response.request(), response, a, voidAtmosphereHandler);
            this.setDefaultSerializer(config, r);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return r;
    }

    @Override
    public AtmosphereResource create(AtmosphereConfig config, String uuid) {
        AtmosphereResponse response = AtmosphereResponse.newInstance();
        response.setHeader("X-Atmosphere-tracking-id", uuid);
        return this.create(config, noOps, AtmosphereRequest.newInstance(), response, config.framework().getAsyncSupport(), noOpsHandler);
    }

    @Override
    public AtmosphereResource create(AtmosphereConfig config, String uuid, AtmosphereRequest request) {
        AtmosphereResponse response = AtmosphereResponse.newInstance();
        response.setHeader("X-Atmosphere-tracking-id", uuid);
        return this.create(config, noOps, request, response, config.framework().getAsyncSupport(), noOpsHandler);
    }

    @Override
    public AtmosphereResource remove(String uuid) {
        logger.trace("Removing: {}", (Object)uuid);
        AtmosphereResource r = this.resources.remove(uuid);
        if (r != null) {
            r.removeFromAllBroadcasters();
        }
        return r;
    }

    @Override
    public AtmosphereResource find(String uuid) {
        if (uuid == null) {
            return null;
        }
        return this.resources.get(uuid);
    }

    @Override
    public void locate(String uuid, AtmosphereResourceFactory.Async async) {
        AtmosphereResource r = this.find(uuid);
        if (r != null) {
            async.available(r);
        }
    }

    @Override
    @Deprecated
    public Set<Broadcaster> broadcasters(String uuid) {
        AtmosphereResource r = this.find(uuid);
        return new HashSet<Broadcaster>(r.broadcasters());
    }

    @Override
    public void registerUuidForFindCandidate(AtmosphereResource r) {
        logger.trace("Adding: {}", (Object)r);
        this.resources.put(r.uuid(), r);
    }

    @Override
    public void unRegisterUuidForFindCandidate(AtmosphereResource r) {
        AtmosphereResource o = this.resources.remove(r.uuid());
        if (o != null) {
            logger.trace("Removing: {}", (Object)r);
        }
    }

    @Override
    public void destroy() {
        this.resources.clear();
    }

    @Override
    public ConcurrentMap<String, AtmosphereResource> resources() {
        return this.resources;
    }

    @Override
    public Collection<AtmosphereResource> findAll() {
        return this.resources.values();
    }

    private void setDefaultSerializer(AtmosphereConfig config, AtmosphereResource r) throws Exception {
        Class<Serializer> serializerClass = config.framework().getDefaultSerializerClass();
        if (serializerClass != null) {
            Serializer serializer = config.framework().newClassInstance(Serializer.class, serializerClass);
            r.setSerializer(serializer);
        }
    }
}

