/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import javax.servlet.ServletException;
import org.atmosphere.container.Jetty7CometSupport;
import org.atmosphere.container.JettyWebSocketUtil;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.websocket.WebSocketProcessor;
import org.eclipse.jetty.websocket.WebSocketFactory;

public class JettyAsyncSupportWithWebSocket
extends Jetty7CometSupport {
    private static final Logger logger = LoggerFactory.getLogger(JettyAsyncSupportWithWebSocket.class);
    private final WebSocketFactory webSocketFactory;

    public JettyAsyncSupportWithWebSocket(AtmosphereConfig config) {
        super(config);
        Object wsf;
        WebSocketProcessor webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(config.framework());
        try {
            String[] jettyVersion = config.getServletContext().getServerInfo().substring(6).split("\\.");
            wsf = Integer.valueOf(jettyVersion[0]) > 7 || Integer.valueOf(jettyVersion[0]) == 7 && Integer.valueOf(jettyVersion[1]) > 4 ? JettyWebSocketUtil.getFactory(config, webSocketProcessor) : null;
        }
        catch (Throwable e) {
            try {
                logger.trace("Unable to parse Jetty version {}", (Object)config.getServletContext().getServerInfo());
            }
            catch (Throwable t) {
                // empty catch block
            }
            wsf = JettyWebSocketUtil.getFactory(config, webSocketProcessor);
        }
        this.webSocketFactory = wsf;
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = JettyWebSocketUtil.doService(this, req, res, this.webSocketFactory);
        return action == null ? super.service(req, res) : action;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }
}

