/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.atmosphere.config.AtmosphereHandlerConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.MetaBroadcaster;

public class AtmosphereConfig {
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereConfig.class);
    private final List<AtmosphereHandlerConfig> atmosphereHandlerConfig = new ArrayList<AtmosphereHandlerConfig>();
    private boolean supportSession;
    private boolean sessionTimeoutRemovalAllowed;
    private boolean throwExceptionOnCloned;
    private final AtmosphereFramework framework;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    protected final List<ShutdownHook> shutdownHooks = new ArrayList<ShutdownHook>();
    protected final List<StartupHook> startUpHook = new ArrayList<StartupHook>();

    public AtmosphereConfig(AtmosphereFramework framework) {
        this.framework = framework;
    }

    public List<AtmosphereHandlerConfig> getAtmosphereHandlerConfig() {
        return this.atmosphereHandlerConfig;
    }

    public AtmosphereFramework framework() {
        return this.framework;
    }

    public ServletConfig getServletConfig() {
        return this.framework.getServletConfig();
    }

    public ServletContext getServletContext() {
        return this.framework.getServletContext();
    }

    public String getWebServerName() {
        return this.framework.getAsyncSupport().getContainerName();
    }

    public Map<String, AtmosphereFramework.AtmosphereHandlerWrapper> handlers() {
        return this.framework.getAtmosphereHandlers();
    }

    public String getInitParameter(String name) {
        try {
            return this.framework.getServletConfig().getInitParameter(name);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public Enumeration<String> getInitParameterNames() {
        return this.framework().getServletConfig().getInitParameterNames();
    }

    public boolean isSupportSession() {
        return this.supportSession;
    }

    public void setSupportSession(boolean supportSession) {
        this.supportSession = supportSession;
    }

    public boolean isSessionTimeoutRemovalAllowed() {
        return this.sessionTimeoutRemovalAllowed;
    }

    public void setSessionTimeoutRemovalAllowed(boolean sessionTimeoutRemovalAllowed) {
        this.sessionTimeoutRemovalAllowed = sessionTimeoutRemovalAllowed;
    }

    public boolean isThrowExceptionOnCloned() {
        return this.throwExceptionOnCloned;
    }

    public void setThrowExceptionOnCloned(boolean throwExceptionOnCloned) {
        this.throwExceptionOnCloned = throwExceptionOnCloned;
    }

    public BroadcasterFactory getBroadcasterFactory() {
        return this.framework.getBroadcasterFactory();
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    protected void destroy() {
        for (ShutdownHook h : this.shutdownHooks) {
            try {
                h.shutdown();
            }
            catch (Exception ex) {
                logger.warn("", (Throwable)ex);
            }
        }
        this.properties.clear();
        this.shutdownHooks.clear();
        this.startUpHook.clear();
        this.atmosphereHandlerConfig.clear();
    }

    protected void initComplete() {
        for (StartupHook h : this.startUpHook) {
            try {
                h.started(this.framework);
            }
            catch (Exception ex) {
                logger.warn("", (Throwable)ex);
            }
        }
        this.startUpHook.clear();
    }

    public AtmosphereConfig shutdownHook(ShutdownHook s) {
        this.shutdownHooks.add(s);
        return this;
    }

    public AtmosphereConfig startupHook(StartupHook s) {
        this.startUpHook.add(s);
        return this;
    }

    public String getInitParameter(String key, String defaultValue) {
        String s = this.getInitParameter(key);
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    public boolean getInitParameter(String key, boolean defaultValue) {
        String s = this.getInitParameter(key);
        if (s == null) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    public AtmosphereResourceFactory resourcesFactory() {
        return this.framework.atmosphereFactory();
    }

    public MetaBroadcaster metaBroadcaster() {
        return this.framework.metaBroadcaster();
    }

    public static interface StartupHook {
        public void started(AtmosphereFramework var1);
    }

    public static interface ShutdownHook {
        public void shutdown();
    }
}

